/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ContainerStateTerminated is a terminated state of a container.")
@JsonPropertyOrder(value={"containerID", "exitCode", "finishedAt", "message", "reason", "signal", "startedAt"})
public class IoK8sApiCoreV1ContainerStateTerminated {
    public static final String JSON_PROPERTY_CONTAINER_I_D = "containerID";
    private String containerID;
    public static final String JSON_PROPERTY_EXIT_CODE = "exitCode";
    private Integer exitCode;
    public static final String JSON_PROPERTY_FINISHED_AT = "finishedAt";
    private OffsetDateTime finishedAt;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_REASON = "reason";
    private String reason;
    public static final String JSON_PROPERTY_SIGNAL = "signal";
    private Integer signal;
    public static final String JSON_PROPERTY_STARTED_AT = "startedAt";
    private OffsetDateTime startedAt;

    public IoK8sApiCoreV1ContainerStateTerminated containerID(String containerID) {
        this.containerID = containerID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container's ID in the format 'docker://<container_id>'")
    @JsonProperty(value="containerID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContainerID() {
        return this.containerID;
    }

    public void setContainerID(String containerID) {
        this.containerID = containerID;
    }

    public IoK8sApiCoreV1ContainerStateTerminated exitCode(Integer exitCode) {
        this.exitCode = exitCode;
        return this;
    }

    @ApiModelProperty(required=true, value="Exit status from the last termination of the container")
    @JsonProperty(value="exitCode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    public IoK8sApiCoreV1ContainerStateTerminated finishedAt(OffsetDateTime finishedAt) {
        this.finishedAt = finishedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.")
    @JsonProperty(value="finishedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getFinishedAt() {
        return this.finishedAt;
    }

    public void setFinishedAt(OffsetDateTime finishedAt) {
        this.finishedAt = finishedAt;
    }

    public IoK8sApiCoreV1ContainerStateTerminated message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Message regarding the last termination of the container")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public IoK8sApiCoreV1ContainerStateTerminated reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="(brief) reason from the last termination of the container")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public IoK8sApiCoreV1ContainerStateTerminated signal(Integer signal) {
        this.signal = signal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Signal from the last termination of the container")
    @JsonProperty(value="signal")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSignal() {
        return this.signal;
    }

    public void setSignal(Integer signal) {
        this.signal = signal;
    }

    public IoK8sApiCoreV1ContainerStateTerminated startedAt(OffsetDateTime startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.")
    @JsonProperty(value="startedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(OffsetDateTime startedAt) {
        this.startedAt = startedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1ContainerStateTerminated ioK8sApiCoreV1ContainerStateTerminated = (IoK8sApiCoreV1ContainerStateTerminated)o;
        return Objects.equals(this.containerID, ioK8sApiCoreV1ContainerStateTerminated.containerID) && Objects.equals(this.exitCode, ioK8sApiCoreV1ContainerStateTerminated.exitCode) && Objects.equals(this.finishedAt, ioK8sApiCoreV1ContainerStateTerminated.finishedAt) && Objects.equals(this.message, ioK8sApiCoreV1ContainerStateTerminated.message) && Objects.equals(this.reason, ioK8sApiCoreV1ContainerStateTerminated.reason) && Objects.equals(this.signal, ioK8sApiCoreV1ContainerStateTerminated.signal) && Objects.equals(this.startedAt, ioK8sApiCoreV1ContainerStateTerminated.startedAt);
    }

    public int hashCode() {
        return Objects.hash(this.containerID, this.exitCode, this.finishedAt, this.message, this.reason, this.signal, this.startedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1ContainerStateTerminated {\n");
        sb.append("    containerID: ").append(this.toIndentedString(this.containerID)).append("\n");
        sb.append("    exitCode: ").append(this.toIndentedString(this.exitCode)).append("\n");
        sb.append("    finishedAt: ").append(this.toIndentedString(this.finishedAt)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    signal: ").append(this.toIndentedString(this.signal)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

