/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1ContainerState;

@ApiModel(description="ContainerStatus contains details for the current status of this container.")
@JsonPropertyOrder(value={"containerID", "image", "imageID", "lastState", "name", "ready", "restartCount", "started", "state"})
public class IoK8sApiCoreV1ContainerStatus {
    public static final String JSON_PROPERTY_CONTAINER_I_D = "containerID";
    private String containerID;
    public static final String JSON_PROPERTY_IMAGE = "image";
    private String image;
    public static final String JSON_PROPERTY_IMAGE_I_D = "imageID";
    private String imageID;
    public static final String JSON_PROPERTY_LAST_STATE = "lastState";
    private IoK8sApiCoreV1ContainerState lastState;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_READY = "ready";
    private Boolean ready;
    public static final String JSON_PROPERTY_RESTART_COUNT = "restartCount";
    private Integer restartCount;
    public static final String JSON_PROPERTY_STARTED = "started";
    private Boolean started;
    public static final String JSON_PROPERTY_STATE = "state";
    private IoK8sApiCoreV1ContainerState state;

    public IoK8sApiCoreV1ContainerStatus containerID(String containerID) {
        this.containerID = containerID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container's ID in the format 'docker://<container_id>'.")
    @JsonProperty(value="containerID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContainerID() {
        return this.containerID;
    }

    public void setContainerID(String containerID) {
        this.containerID = containerID;
    }

    public IoK8sApiCoreV1ContainerStatus image(String image) {
        this.image = image;
        return this;
    }

    @ApiModelProperty(required=true, value="The image the container is running. More info: https://kubernetes.io/docs/concepts/containers/images")
    @JsonProperty(value="image")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public IoK8sApiCoreV1ContainerStatus imageID(String imageID) {
        this.imageID = imageID;
        return this;
    }

    @ApiModelProperty(required=true, value="ImageID of the container's image.")
    @JsonProperty(value="imageID")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getImageID() {
        return this.imageID;
    }

    public void setImageID(String imageID) {
        this.imageID = imageID;
    }

    public IoK8sApiCoreV1ContainerStatus lastState(IoK8sApiCoreV1ContainerState lastState) {
        this.lastState = lastState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="lastState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1ContainerState getLastState() {
        return this.lastState;
    }

    public void setLastState(IoK8sApiCoreV1ContainerState lastState) {
        this.lastState = lastState;
    }

    public IoK8sApiCoreV1ContainerStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="This must be a DNS_LABEL. Each container in a pod must have a unique name. Cannot be updated.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IoK8sApiCoreV1ContainerStatus ready(Boolean ready) {
        this.ready = ready;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies whether the container has passed its readiness probe.")
    @JsonProperty(value="ready")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getReady() {
        return this.ready;
    }

    public void setReady(Boolean ready) {
        this.ready = ready;
    }

    public IoK8sApiCoreV1ContainerStatus restartCount(Integer restartCount) {
        this.restartCount = restartCount;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of times the container has been restarted, currently based on the number of dead containers that have not yet been removed. Note that this is calculated from dead containers. But those containers are subject to garbage collection. This value will get capped at 5 by GC.")
    @JsonProperty(value="restartCount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getRestartCount() {
        return this.restartCount;
    }

    public void setRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
    }

    public IoK8sApiCoreV1ContainerStatus started(Boolean started) {
        this.started = started;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies whether the container has passed its startup probe. Initialized as false, becomes true after startupProbe is considered successful. Resets to false when the container is restarted, or if kubelet loses state temporarily. Is always true when no startupProbe is defined.")
    @JsonProperty(value="started")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getStarted() {
        return this.started;
    }

    public void setStarted(Boolean started) {
        this.started = started;
    }

    public IoK8sApiCoreV1ContainerStatus state(IoK8sApiCoreV1ContainerState state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1ContainerState getState() {
        return this.state;
    }

    public void setState(IoK8sApiCoreV1ContainerState state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1ContainerStatus ioK8sApiCoreV1ContainerStatus = (IoK8sApiCoreV1ContainerStatus)o;
        return Objects.equals(this.containerID, ioK8sApiCoreV1ContainerStatus.containerID) && Objects.equals(this.image, ioK8sApiCoreV1ContainerStatus.image) && Objects.equals(this.imageID, ioK8sApiCoreV1ContainerStatus.imageID) && Objects.equals(this.lastState, ioK8sApiCoreV1ContainerStatus.lastState) && Objects.equals(this.name, ioK8sApiCoreV1ContainerStatus.name) && Objects.equals(this.ready, ioK8sApiCoreV1ContainerStatus.ready) && Objects.equals(this.restartCount, ioK8sApiCoreV1ContainerStatus.restartCount) && Objects.equals(this.started, ioK8sApiCoreV1ContainerStatus.started) && Objects.equals(this.state, ioK8sApiCoreV1ContainerStatus.state);
    }

    public int hashCode() {
        return Objects.hash(this.containerID, this.image, this.imageID, this.lastState, this.name, this.ready, this.restartCount, this.started, this.state);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1ContainerStatus {\n");
        sb.append("    containerID: ").append(this.toIndentedString(this.containerID)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    imageID: ").append(this.toIndentedString(this.imageID)).append("\n");
        sb.append("    lastState: ").append(this.toIndentedString(this.lastState)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ready: ").append(this.toIndentedString(this.ready)).append("\n");
        sb.append("    restartCount: ").append(this.toIndentedString(this.restartCount)).append("\n");
        sb.append("    started: ").append(this.toIndentedString(this.started)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

