/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1ObjectReference;

@ApiModel(description="EndpointAddress is a tuple that describes single IP address.")
@JsonPropertyOrder(value={"hostname", "ip", "nodeName", "targetRef"})
public class IoK8sApiCoreV1EndpointAddress {
    public static final String JSON_PROPERTY_HOSTNAME = "hostname";
    private String hostname;
    public static final String JSON_PROPERTY_IP = "ip";
    private String ip;
    public static final String JSON_PROPERTY_NODE_NAME = "nodeName";
    private String nodeName;
    public static final String JSON_PROPERTY_TARGET_REF = "targetRef";
    private IoK8sApiCoreV1ObjectReference targetRef;

    public IoK8sApiCoreV1EndpointAddress hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Hostname of this endpoint")
    @JsonProperty(value="hostname")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public IoK8sApiCoreV1EndpointAddress ip(String ip) {
        this.ip = ip;
        return this;
    }

    @ApiModelProperty(required=true, value="The IP of this endpoint. May not be loopback (127.0.0.0/8), link-local (169.254.0.0/16), or link-local multicast ((224.0.0.0/24). IPv6 is also accepted but not fully supported on all platforms. Also, certain kubernetes components, like kube-proxy, are not IPv6 ready.")
    @JsonProperty(value="ip")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public IoK8sApiCoreV1EndpointAddress nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.")
    @JsonProperty(value="nodeName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public IoK8sApiCoreV1EndpointAddress targetRef(IoK8sApiCoreV1ObjectReference targetRef) {
        this.targetRef = targetRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="targetRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1ObjectReference getTargetRef() {
        return this.targetRef;
    }

    public void setTargetRef(IoK8sApiCoreV1ObjectReference targetRef) {
        this.targetRef = targetRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1EndpointAddress ioK8sApiCoreV1EndpointAddress = (IoK8sApiCoreV1EndpointAddress)o;
        return Objects.equals(this.hostname, ioK8sApiCoreV1EndpointAddress.hostname) && Objects.equals(this.ip, ioK8sApiCoreV1EndpointAddress.ip) && Objects.equals(this.nodeName, ioK8sApiCoreV1EndpointAddress.nodeName) && Objects.equals(this.targetRef, ioK8sApiCoreV1EndpointAddress.targetRef);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.ip, this.nodeName, this.targetRef);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1EndpointAddress {\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    nodeName: ").append(this.toIndentedString(this.nodeName)).append("\n");
        sb.append("    targetRef: ").append(this.toIndentedString(this.targetRef)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

