/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1EndpointAddress;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1EndpointPort;

@ApiModel(description="EndpointSubset is a group of addresses with a common set of ports. The expanded set of endpoints is the Cartesian product of Addresses x Ports. For example, given:   {     Addresses: [{\"ip\": \"10.10.1.1\"}, {\"ip\": \"10.10.2.2\"}],     Ports:     [{\"name\": \"a\", \"port\": 8675}, {\"name\": \"b\", \"port\": 309}]   } The resulting set of endpoints can be viewed as:     a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],     b: [ 10.10.1.1:309, 10.10.2.2:309 ]")
@JsonPropertyOrder(value={"addresses", "notReadyAddresses", "ports"})
public class IoK8sApiCoreV1EndpointSubset {
    public static final String JSON_PROPERTY_ADDRESSES = "addresses";
    private List<IoK8sApiCoreV1EndpointAddress> addresses = null;
    public static final String JSON_PROPERTY_NOT_READY_ADDRESSES = "notReadyAddresses";
    private List<IoK8sApiCoreV1EndpointAddress> notReadyAddresses = null;
    public static final String JSON_PROPERTY_PORTS = "ports";
    private List<IoK8sApiCoreV1EndpointPort> ports = null;

    public IoK8sApiCoreV1EndpointSubset addresses(List<IoK8sApiCoreV1EndpointAddress> addresses) {
        this.addresses = addresses;
        return this;
    }

    public IoK8sApiCoreV1EndpointSubset addAddressesItem(IoK8sApiCoreV1EndpointAddress addressesItem) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<IoK8sApiCoreV1EndpointAddress>();
        }
        this.addresses.add(addressesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IP addresses which offer the related ports that are marked as ready. These endpoints should be considered safe for load balancers and clients to utilize.")
    @JsonProperty(value="addresses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1EndpointAddress> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<IoK8sApiCoreV1EndpointAddress> addresses) {
        this.addresses = addresses;
    }

    public IoK8sApiCoreV1EndpointSubset notReadyAddresses(List<IoK8sApiCoreV1EndpointAddress> notReadyAddresses) {
        this.notReadyAddresses = notReadyAddresses;
        return this;
    }

    public IoK8sApiCoreV1EndpointSubset addNotReadyAddressesItem(IoK8sApiCoreV1EndpointAddress notReadyAddressesItem) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList<IoK8sApiCoreV1EndpointAddress>();
        }
        this.notReadyAddresses.add(notReadyAddressesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IP addresses which offer the related ports but are not currently marked as ready because they have not yet finished starting, have recently failed a readiness check, or have recently failed a liveness check.")
    @JsonProperty(value="notReadyAddresses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1EndpointAddress> getNotReadyAddresses() {
        return this.notReadyAddresses;
    }

    public void setNotReadyAddresses(List<IoK8sApiCoreV1EndpointAddress> notReadyAddresses) {
        this.notReadyAddresses = notReadyAddresses;
    }

    public IoK8sApiCoreV1EndpointSubset ports(List<IoK8sApiCoreV1EndpointPort> ports) {
        this.ports = ports;
        return this;
    }

    public IoK8sApiCoreV1EndpointSubset addPortsItem(IoK8sApiCoreV1EndpointPort portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<IoK8sApiCoreV1EndpointPort>();
        }
        this.ports.add(portsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Port numbers available on the related IP addresses.")
    @JsonProperty(value="ports")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1EndpointPort> getPorts() {
        return this.ports;
    }

    public void setPorts(List<IoK8sApiCoreV1EndpointPort> ports) {
        this.ports = ports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1EndpointSubset ioK8sApiCoreV1EndpointSubset = (IoK8sApiCoreV1EndpointSubset)o;
        return Objects.equals(this.addresses, ioK8sApiCoreV1EndpointSubset.addresses) && Objects.equals(this.notReadyAddresses, ioK8sApiCoreV1EndpointSubset.notReadyAddresses) && Objects.equals(this.ports, ioK8sApiCoreV1EndpointSubset.ports);
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.notReadyAddresses, this.ports);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1EndpointSubset {\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    notReadyAddresses: ").append(this.toIndentedString(this.notReadyAddresses)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

