/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1EnvVarSource;

@ApiModel(description="EnvVar represents an environment variable present in a Container.")
@JsonPropertyOrder(value={"name", "value", "valueFrom"})
public class IoK8sApiCoreV1EnvVar {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_VALUE = "value";
    private String value;
    public static final String JSON_PROPERTY_VALUE_FROM = "valueFrom";
    private IoK8sApiCoreV1EnvVarSource valueFrom;

    public IoK8sApiCoreV1EnvVar name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the environment variable. Must be a C_IDENTIFIER.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IoK8sApiCoreV1EnvVar value(String value) {
        this.value = value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to \"\".")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public IoK8sApiCoreV1EnvVar valueFrom(IoK8sApiCoreV1EnvVarSource valueFrom) {
        this.valueFrom = valueFrom;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="valueFrom")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1EnvVarSource getValueFrom() {
        return this.valueFrom;
    }

    public void setValueFrom(IoK8sApiCoreV1EnvVarSource valueFrom) {
        this.valueFrom = valueFrom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1EnvVar ioK8sApiCoreV1EnvVar = (IoK8sApiCoreV1EnvVar)o;
        return Objects.equals(this.name, ioK8sApiCoreV1EnvVar.name) && Objects.equals(this.value, ioK8sApiCoreV1EnvVar.value) && Objects.equals(this.valueFrom, ioK8sApiCoreV1EnvVar.valueFrom);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.valueFrom);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1EnvVar {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    valueFrom: ").append(this.toIndentedString(this.valueFrom)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

