/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a Fibre Channel volume. Fibre Channel volumes can only be mounted as read/write once. Fibre Channel volumes support ownership management and SELinux relabeling.")
@JsonPropertyOrder(value={"fsType", "lun", "readOnly", "targetWWNs", "wwids"})
public class IoK8sApiCoreV1FCVolumeSource {
    public static final String JSON_PROPERTY_FS_TYPE = "fsType";
    private String fsType;
    public static final String JSON_PROPERTY_LUN = "lun";
    private Integer lun;
    public static final String JSON_PROPERTY_READ_ONLY = "readOnly";
    private Boolean readOnly;
    public static final String JSON_PROPERTY_TARGET_W_W_NS = "targetWWNs";
    private List<String> targetWWNs = null;
    public static final String JSON_PROPERTY_WWIDS = "wwids";
    private List<String> wwids = null;

    public IoK8sApiCoreV1FCVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.")
    @JsonProperty(value="fsType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public IoK8sApiCoreV1FCVolumeSource lun(Integer lun) {
        this.lun = lun;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: FC target lun number")
    @JsonProperty(value="lun")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLun() {
        return this.lun;
    }

    public void setLun(Integer lun) {
        this.lun = lun;
    }

    public IoK8sApiCoreV1FCVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    @JsonProperty(value="readOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public IoK8sApiCoreV1FCVolumeSource targetWWNs(List<String> targetWWNs) {
        this.targetWWNs = targetWWNs;
        return this;
    }

    public IoK8sApiCoreV1FCVolumeSource addTargetWWNsItem(String targetWWNsItem) {
        if (this.targetWWNs == null) {
            this.targetWWNs = new ArrayList<String>();
        }
        this.targetWWNs.add(targetWWNsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: FC target worldwide names (WWNs)")
    @JsonProperty(value="targetWWNs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTargetWWNs() {
        return this.targetWWNs;
    }

    public void setTargetWWNs(List<String> targetWWNs) {
        this.targetWWNs = targetWWNs;
    }

    public IoK8sApiCoreV1FCVolumeSource wwids(List<String> wwids) {
        this.wwids = wwids;
        return this;
    }

    public IoK8sApiCoreV1FCVolumeSource addWwidsItem(String wwidsItem) {
        if (this.wwids == null) {
            this.wwids = new ArrayList<String>();
        }
        this.wwids.add(wwidsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.")
    @JsonProperty(value="wwids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getWwids() {
        return this.wwids;
    }

    public void setWwids(List<String> wwids) {
        this.wwids = wwids;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1FCVolumeSource ioK8sApiCoreV1FCVolumeSource = (IoK8sApiCoreV1FCVolumeSource)o;
        return Objects.equals(this.fsType, ioK8sApiCoreV1FCVolumeSource.fsType) && Objects.equals(this.lun, ioK8sApiCoreV1FCVolumeSource.lun) && Objects.equals(this.readOnly, ioK8sApiCoreV1FCVolumeSource.readOnly) && Objects.equals(this.targetWWNs, ioK8sApiCoreV1FCVolumeSource.targetWWNs) && Objects.equals(this.wwids, ioK8sApiCoreV1FCVolumeSource.wwids);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.lun, this.readOnly, this.targetWWNs, this.wwids);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1FCVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    lun: ").append(this.toIndentedString(this.lun)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    targetWWNs: ").append(this.toIndentedString(this.targetWWNs)).append("\n");
        sb.append("    wwids: ").append(this.toIndentedString(this.wwids)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

