/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1SecretReference;

@ApiModel(description="FlexPersistentVolumeSource represents a generic persistent volume resource that is provisioned/attached using an exec based plugin.")
@JsonPropertyOrder(value={"driver", "fsType", "options", "readOnly", "secretRef"})
public class IoK8sApiCoreV1FlexPersistentVolumeSource {
    public static final String JSON_PROPERTY_DRIVER = "driver";
    private String driver;
    public static final String JSON_PROPERTY_FS_TYPE = "fsType";
    private String fsType;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private Map<String, String> options = null;
    public static final String JSON_PROPERTY_READ_ONLY = "readOnly";
    private Boolean readOnly;
    public static final String JSON_PROPERTY_SECRET_REF = "secretRef";
    private IoK8sApiCoreV1SecretReference secretRef;

    public IoK8sApiCoreV1FlexPersistentVolumeSource driver(String driver) {
        this.driver = driver;
        return this;
    }

    @ApiModelProperty(required=true, value="Driver is the name of the driver to use for this volume.")
    @JsonProperty(value="driver")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public IoK8sApiCoreV1FlexPersistentVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". The default filesystem depends on FlexVolume script.")
    @JsonProperty(value="fsType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public IoK8sApiCoreV1FlexPersistentVolumeSource options(Map<String, String> options) {
        this.options = options;
        return this;
    }

    public IoK8sApiCoreV1FlexPersistentVolumeSource putOptionsItem(String key, String optionsItem) {
        if (this.options == null) {
            this.options = new HashMap<String, String>();
        }
        this.options.put(key, optionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Extra command options if any.")
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public IoK8sApiCoreV1FlexPersistentVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    @JsonProperty(value="readOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public IoK8sApiCoreV1FlexPersistentVolumeSource secretRef(IoK8sApiCoreV1SecretReference secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="secretRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1SecretReference getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(IoK8sApiCoreV1SecretReference secretRef) {
        this.secretRef = secretRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1FlexPersistentVolumeSource ioK8sApiCoreV1FlexPersistentVolumeSource = (IoK8sApiCoreV1FlexPersistentVolumeSource)o;
        return Objects.equals(this.driver, ioK8sApiCoreV1FlexPersistentVolumeSource.driver) && Objects.equals(this.fsType, ioK8sApiCoreV1FlexPersistentVolumeSource.fsType) && Objects.equals(this.options, ioK8sApiCoreV1FlexPersistentVolumeSource.options) && Objects.equals(this.readOnly, ioK8sApiCoreV1FlexPersistentVolumeSource.readOnly) && Objects.equals(this.secretRef, ioK8sApiCoreV1FlexPersistentVolumeSource.secretRef);
    }

    public int hashCode() {
        return Objects.hash(this.driver, this.fsType, this.options, this.readOnly, this.secretRef);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1FlexPersistentVolumeSource {\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    secretRef: ").append(this.toIndentedString(this.secretRef)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

