/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a Flocker volume mounted by the Flocker agent. One and only one of datasetName and datasetUUID should be set. Flocker volumes do not support ownership management or SELinux relabeling.")
@JsonPropertyOrder(value={"datasetName", "datasetUUID"})
public class IoK8sApiCoreV1FlockerVolumeSource {
    public static final String JSON_PROPERTY_DATASET_NAME = "datasetName";
    private String datasetName;
    public static final String JSON_PROPERTY_DATASET_U_U_I_D = "datasetUUID";
    private String datasetUUID;

    public IoK8sApiCoreV1FlockerVolumeSource datasetName(String datasetName) {
        this.datasetName = datasetName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated")
    @JsonProperty(value="datasetName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDatasetName() {
        return this.datasetName;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public IoK8sApiCoreV1FlockerVolumeSource datasetUUID(String datasetUUID) {
        this.datasetUUID = datasetUUID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UUID of the dataset. This is unique identifier of a Flocker dataset")
    @JsonProperty(value="datasetUUID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDatasetUUID() {
        return this.datasetUUID;
    }

    public void setDatasetUUID(String datasetUUID) {
        this.datasetUUID = datasetUUID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1FlockerVolumeSource ioK8sApiCoreV1FlockerVolumeSource = (IoK8sApiCoreV1FlockerVolumeSource)o;
        return Objects.equals(this.datasetName, ioK8sApiCoreV1FlockerVolumeSource.datasetName) && Objects.equals(this.datasetUUID, ioK8sApiCoreV1FlockerVolumeSource.datasetUUID);
    }

    public int hashCode() {
        return Objects.hash(this.datasetName, this.datasetUUID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1FlockerVolumeSource {\n");
        sb.append("    datasetName: ").append(this.toIndentedString(this.datasetName)).append("\n");
        sb.append("    datasetUUID: ").append(this.toIndentedString(this.datasetUUID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

