/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a volume that is populated with the contents of a git repository. Git repo volumes do not support ownership management. Git repo volumes support SELinux relabeling.  DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.")
@JsonPropertyOrder(value={"directory", "repository", "revision"})
public class IoK8sApiCoreV1GitRepoVolumeSource {
    public static final String JSON_PROPERTY_DIRECTORY = "directory";
    private String directory;
    public static final String JSON_PROPERTY_REPOSITORY = "repository";
    private String repository;
    public static final String JSON_PROPERTY_REVISION = "revision";
    private String revision;

    public IoK8sApiCoreV1GitRepoVolumeSource directory(String directory) {
        this.directory = directory;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.")
    @JsonProperty(value="directory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public IoK8sApiCoreV1GitRepoVolumeSource repository(String repository) {
        this.repository = repository;
        return this;
    }

    @ApiModelProperty(required=true, value="Repository URL")
    @JsonProperty(value="repository")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public IoK8sApiCoreV1GitRepoVolumeSource revision(String revision) {
        this.revision = revision;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Commit hash for the specified revision.")
    @JsonProperty(value="revision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1GitRepoVolumeSource ioK8sApiCoreV1GitRepoVolumeSource = (IoK8sApiCoreV1GitRepoVolumeSource)o;
        return Objects.equals(this.directory, ioK8sApiCoreV1GitRepoVolumeSource.directory) && Objects.equals(this.repository, ioK8sApiCoreV1GitRepoVolumeSource.repository) && Objects.equals(this.revision, ioK8sApiCoreV1GitRepoVolumeSource.revision);
    }

    public int hashCode() {
        return Objects.hash(this.directory, this.repository, this.revision);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1GitRepoVolumeSource {\n");
        sb.append("    directory: ").append(this.toIndentedString(this.directory)).append("\n");
        sb.append("    repository: ").append(this.toIndentedString(this.repository)).append("\n");
        sb.append("    revision: ").append(this.toIndentedString(this.revision)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

