/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling.")
@JsonPropertyOrder(value={"endpoints", "endpointsNamespace", "path", "readOnly"})
public class IoK8sApiCoreV1GlusterfsPersistentVolumeSource {
    public static final String JSON_PROPERTY_ENDPOINTS = "endpoints";
    private String endpoints;
    public static final String JSON_PROPERTY_ENDPOINTS_NAMESPACE = "endpointsNamespace";
    private String endpointsNamespace;
    public static final String JSON_PROPERTY_PATH = "path";
    private String path;
    public static final String JSON_PROPERTY_READ_ONLY = "readOnly";
    private Boolean readOnly;

    public IoK8sApiCoreV1GlusterfsPersistentVolumeSource endpoints(String endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    @ApiModelProperty(required=true, value="EndpointsName is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod")
    @JsonProperty(value="endpoints")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(String endpoints) {
        this.endpoints = endpoints;
    }

    public IoK8sApiCoreV1GlusterfsPersistentVolumeSource endpointsNamespace(String endpointsNamespace) {
        this.endpointsNamespace = endpointsNamespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EndpointsNamespace is the namespace that contains Glusterfs endpoint. If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod")
    @JsonProperty(value="endpointsNamespace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEndpointsNamespace() {
        return this.endpointsNamespace;
    }

    public void setEndpointsNamespace(String endpointsNamespace) {
        this.endpointsNamespace = endpointsNamespace;
    }

    public IoK8sApiCoreV1GlusterfsPersistentVolumeSource path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(required=true, value="Path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod")
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public IoK8sApiCoreV1GlusterfsPersistentVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod")
    @JsonProperty(value="readOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1GlusterfsPersistentVolumeSource ioK8sApiCoreV1GlusterfsPersistentVolumeSource = (IoK8sApiCoreV1GlusterfsPersistentVolumeSource)o;
        return Objects.equals(this.endpoints, ioK8sApiCoreV1GlusterfsPersistentVolumeSource.endpoints) && Objects.equals(this.endpointsNamespace, ioK8sApiCoreV1GlusterfsPersistentVolumeSource.endpointsNamespace) && Objects.equals(this.path, ioK8sApiCoreV1GlusterfsPersistentVolumeSource.path) && Objects.equals(this.readOnly, ioK8sApiCoreV1GlusterfsPersistentVolumeSource.readOnly);
    }

    public int hashCode() {
        return Objects.hash(this.endpoints, this.endpointsNamespace, this.path, this.readOnly);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1GlusterfsPersistentVolumeSource {\n");
        sb.append("    endpoints: ").append(this.toIndentedString(this.endpoints)).append("\n");
        sb.append("    endpointsNamespace: ").append(this.toIndentedString(this.endpointsNamespace)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

