/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1HTTPHeader;

@ApiModel(description="HTTPGetAction describes an action based on HTTP Get requests.")
@JsonPropertyOrder(value={"host", "httpHeaders", "path", "port", "scheme"})
public class IoK8sApiCoreV1HTTPGetAction {
    public static final String JSON_PROPERTY_HOST = "host";
    private String host;
    public static final String JSON_PROPERTY_HTTP_HEADERS = "httpHeaders";
    private List<IoK8sApiCoreV1HTTPHeader> httpHeaders = null;
    public static final String JSON_PROPERTY_PATH = "path";
    private String path;
    public static final String JSON_PROPERTY_PORT = "port";
    private String port;
    public static final String JSON_PROPERTY_SCHEME = "scheme";
    private String scheme;

    public IoK8sApiCoreV1HTTPGetAction host(String host) {
        this.host = host;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Host name to connect to, defaults to the pod IP. You probably want to set \"Host\" in httpHeaders instead.")
    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public IoK8sApiCoreV1HTTPGetAction httpHeaders(List<IoK8sApiCoreV1HTTPHeader> httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    public IoK8sApiCoreV1HTTPGetAction addHttpHeadersItem(IoK8sApiCoreV1HTTPHeader httpHeadersItem) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList<IoK8sApiCoreV1HTTPHeader>();
        }
        this.httpHeaders.add(httpHeadersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Custom headers to set in the request. HTTP allows repeated headers.")
    @JsonProperty(value="httpHeaders")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1HTTPHeader> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(List<IoK8sApiCoreV1HTTPHeader> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public IoK8sApiCoreV1HTTPGetAction path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Path to access on the HTTP server.")
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public IoK8sApiCoreV1HTTPGetAction port(String port) {
        this.port = port;
        return this;
    }

    @ApiModelProperty(required=true, value="IntOrString is a type that can hold an int32 or a string.  When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type.  This allows you to have, for example, a JSON field that can accept a name or number.")
    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public IoK8sApiCoreV1HTTPGetAction scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Scheme to use for connecting to the host. Defaults to HTTP.")
    @JsonProperty(value="scheme")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1HTTPGetAction ioK8sApiCoreV1HTTPGetAction = (IoK8sApiCoreV1HTTPGetAction)o;
        return Objects.equals(this.host, ioK8sApiCoreV1HTTPGetAction.host) && Objects.equals(this.httpHeaders, ioK8sApiCoreV1HTTPGetAction.httpHeaders) && Objects.equals(this.path, ioK8sApiCoreV1HTTPGetAction.path) && Objects.equals(this.port, ioK8sApiCoreV1HTTPGetAction.port) && Objects.equals(this.scheme, ioK8sApiCoreV1HTTPGetAction.scheme);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.httpHeaders, this.path, this.port, this.scheme);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1HTTPGetAction {\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    httpHeaders: ").append(this.toIndentedString(this.httpHeaders)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    scheme: ").append(this.toIndentedString(this.scheme)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

