/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.")
@JsonPropertyOrder(value={"hostnames", "ip"})
public class IoK8sApiCoreV1HostAlias {
    public static final String JSON_PROPERTY_HOSTNAMES = "hostnames";
    private List<String> hostnames = null;
    public static final String JSON_PROPERTY_IP = "ip";
    private String ip;

    public IoK8sApiCoreV1HostAlias hostnames(List<String> hostnames) {
        this.hostnames = hostnames;
        return this;
    }

    public IoK8sApiCoreV1HostAlias addHostnamesItem(String hostnamesItem) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        this.hostnames.add(hostnamesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Hostnames for the above IP address.")
    @JsonProperty(value="hostnames")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getHostnames() {
        return this.hostnames;
    }

    public void setHostnames(List<String> hostnames) {
        this.hostnames = hostnames;
    }

    public IoK8sApiCoreV1HostAlias ip(String ip) {
        this.ip = ip;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IP address of the host file entry.")
    @JsonProperty(value="ip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1HostAlias ioK8sApiCoreV1HostAlias = (IoK8sApiCoreV1HostAlias)o;
        return Objects.equals(this.hostnames, ioK8sApiCoreV1HostAlias.hostnames) && Objects.equals(this.ip, ioK8sApiCoreV1HostAlias.ip);
    }

    public int hashCode() {
        return Objects.hash(this.hostnames, this.ip);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1HostAlias {\n");
        sb.append("    hostnames: ").append(this.toIndentedString(this.hostnames)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

