/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a host path mapped into a pod. Host path volumes do not support ownership management or SELinux relabeling.")
@JsonPropertyOrder(value={"path", "type"})
public class IoK8sApiCoreV1HostPathVolumeSource {
    public static final String JSON_PROPERTY_PATH = "path";
    private String path;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public IoK8sApiCoreV1HostPathVolumeSource path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(required=true, value="Path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath")
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public IoK8sApiCoreV1HostPathVolumeSource type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type for HostPath Volume Defaults to \"\" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1HostPathVolumeSource ioK8sApiCoreV1HostPathVolumeSource = (IoK8sApiCoreV1HostPathVolumeSource)o;
        return Objects.equals(this.path, ioK8sApiCoreV1HostPathVolumeSource.path) && Objects.equals(this.type, ioK8sApiCoreV1HostPathVolumeSource.type);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1HostPathVolumeSource {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

