/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="LoadBalancerIngress represents the status of a load-balancer ingress point: traffic intended for the service should be sent to an ingress point.")
@JsonPropertyOrder(value={"hostname", "ip"})
public class IoK8sApiCoreV1LoadBalancerIngress {
    public static final String JSON_PROPERTY_HOSTNAME = "hostname";
    private String hostname;
    public static final String JSON_PROPERTY_IP = "ip";
    private String ip;

    public IoK8sApiCoreV1LoadBalancerIngress hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)")
    @JsonProperty(value="hostname")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public IoK8sApiCoreV1LoadBalancerIngress ip(String ip) {
        this.ip = ip;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack load-balancers)")
    @JsonProperty(value="ip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1LoadBalancerIngress ioK8sApiCoreV1LoadBalancerIngress = (IoK8sApiCoreV1LoadBalancerIngress)o;
        return Objects.equals(this.hostname, ioK8sApiCoreV1LoadBalancerIngress.hostname) && Objects.equals(this.ip, ioK8sApiCoreV1LoadBalancerIngress.ip);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.ip);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1LoadBalancerIngress {\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

