/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Local represents directly-attached storage with node affinity (Beta feature)")
@JsonPropertyOrder(value={"fsType", "path"})
public class IoK8sApiCoreV1LocalVolumeSource {
    public static final String JSON_PROPERTY_FS_TYPE = "fsType";
    private String fsType;
    public static final String JSON_PROPERTY_PATH = "path";
    private String path;

    public IoK8sApiCoreV1LocalVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filesystem type to mount. It applies only when the Path is a block device. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". The default value is to auto-select a fileystem if unspecified.")
    @JsonProperty(value="fsType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public IoK8sApiCoreV1LocalVolumeSource path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(required=true, value="The full path to the volume on the node. It can be either a directory or block device (disk, partition, ...).")
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1LocalVolumeSource ioK8sApiCoreV1LocalVolumeSource = (IoK8sApiCoreV1LocalVolumeSource)o;
        return Objects.equals(this.fsType, ioK8sApiCoreV1LocalVolumeSource.fsType) && Objects.equals(this.path, ioK8sApiCoreV1LocalVolumeSource.path);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.path);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1LocalVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

