/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents an NFS mount that lasts the lifetime of a pod. NFS volumes do not support ownership management or SELinux relabeling.")
@JsonPropertyOrder(value={"path", "readOnly", "server"})
public class IoK8sApiCoreV1NFSVolumeSource {
    public static final String JSON_PROPERTY_PATH = "path";
    private String path;
    public static final String JSON_PROPERTY_READ_ONLY = "readOnly";
    private Boolean readOnly;
    public static final String JSON_PROPERTY_SERVER = "server";
    private String server;

    public IoK8sApiCoreV1NFSVolumeSource path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(required=true, value="Path that is exported by the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs")
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public IoK8sApiCoreV1NFSVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ReadOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs")
    @JsonProperty(value="readOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public IoK8sApiCoreV1NFSVolumeSource server(String server) {
        this.server = server;
        return this;
    }

    @ApiModelProperty(required=true, value="Server is the hostname or IP address of the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs")
    @JsonProperty(value="server")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1NFSVolumeSource ioK8sApiCoreV1NFSVolumeSource = (IoK8sApiCoreV1NFSVolumeSource)o;
        return Objects.equals(this.path, ioK8sApiCoreV1NFSVolumeSource.path) && Objects.equals(this.readOnly, ioK8sApiCoreV1NFSVolumeSource.readOnly) && Objects.equals(this.server, ioK8sApiCoreV1NFSVolumeSource.server);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.readOnly, this.server);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1NFSVolumeSource {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    server: ").append(this.toIndentedString(this.server)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

