/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1NodeConfigSource;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1Taint;

@ApiModel(description="NodeSpec describes the attributes that a node is created with.")
@JsonPropertyOrder(value={"configSource", "externalID", "podCIDR", "podCIDRs", "providerID", "taints", "unschedulable"})
public class IoK8sApiCoreV1NodeSpec {
    public static final String JSON_PROPERTY_CONFIG_SOURCE = "configSource";
    private IoK8sApiCoreV1NodeConfigSource configSource;
    public static final String JSON_PROPERTY_EXTERNAL_I_D = "externalID";
    private String externalID;
    public static final String JSON_PROPERTY_POD_C_I_D_R = "podCIDR";
    private String podCIDR;
    public static final String JSON_PROPERTY_POD_C_I_D_RS = "podCIDRs";
    private List<String> podCIDRs = null;
    public static final String JSON_PROPERTY_PROVIDER_I_D = "providerID";
    private String providerID;
    public static final String JSON_PROPERTY_TAINTS = "taints";
    private List<IoK8sApiCoreV1Taint> taints = null;
    public static final String JSON_PROPERTY_UNSCHEDULABLE = "unschedulable";
    private Boolean unschedulable;

    public IoK8sApiCoreV1NodeSpec configSource(IoK8sApiCoreV1NodeConfigSource configSource) {
        this.configSource = configSource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="configSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1NodeConfigSource getConfigSource() {
        return this.configSource;
    }

    public void setConfigSource(IoK8sApiCoreV1NodeConfigSource configSource) {
        this.configSource = configSource;
    }

    public IoK8sApiCoreV1NodeSpec externalID(String externalID) {
        this.externalID = externalID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated. Not all kubelets will set this field. Remove field after 1.13. see: https://issues.k8s.io/61966")
    @JsonProperty(value="externalID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalID() {
        return this.externalID;
    }

    public void setExternalID(String externalID) {
        this.externalID = externalID;
    }

    public IoK8sApiCoreV1NodeSpec podCIDR(String podCIDR) {
        this.podCIDR = podCIDR;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PodCIDR represents the pod IP range assigned to the node.")
    @JsonProperty(value="podCIDR")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPodCIDR() {
        return this.podCIDR;
    }

    public void setPodCIDR(String podCIDR) {
        this.podCIDR = podCIDR;
    }

    public IoK8sApiCoreV1NodeSpec podCIDRs(List<String> podCIDRs) {
        this.podCIDRs = podCIDRs;
        return this;
    }

    public IoK8sApiCoreV1NodeSpec addPodCIDRsItem(String podCIDRsItem) {
        if (this.podCIDRs == null) {
            this.podCIDRs = new ArrayList<String>();
        }
        this.podCIDRs.add(podCIDRsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="podCIDRs represents the IP ranges assigned to the node for usage by Pods on that node. If this field is specified, the 0th entry must match the podCIDR field. It may contain at most 1 value for each of IPv4 and IPv6.")
    @JsonProperty(value="podCIDRs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPodCIDRs() {
        return this.podCIDRs;
    }

    public void setPodCIDRs(List<String> podCIDRs) {
        this.podCIDRs = podCIDRs;
    }

    public IoK8sApiCoreV1NodeSpec providerID(String providerID) {
        this.providerID = providerID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>")
    @JsonProperty(value="providerID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProviderID() {
        return this.providerID;
    }

    public void setProviderID(String providerID) {
        this.providerID = providerID;
    }

    public IoK8sApiCoreV1NodeSpec taints(List<IoK8sApiCoreV1Taint> taints) {
        this.taints = taints;
        return this;
    }

    public IoK8sApiCoreV1NodeSpec addTaintsItem(IoK8sApiCoreV1Taint taintsItem) {
        if (this.taints == null) {
            this.taints = new ArrayList<IoK8sApiCoreV1Taint>();
        }
        this.taints.add(taintsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If specified, the node's taints.")
    @JsonProperty(value="taints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1Taint> getTaints() {
        return this.taints;
    }

    public void setTaints(List<IoK8sApiCoreV1Taint> taints) {
        this.taints = taints;
    }

    public IoK8sApiCoreV1NodeSpec unschedulable(Boolean unschedulable) {
        this.unschedulable = unschedulable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unschedulable controls node schedulability of new pods. By default, node is schedulable. More info: https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration")
    @JsonProperty(value="unschedulable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getUnschedulable() {
        return this.unschedulable;
    }

    public void setUnschedulable(Boolean unschedulable) {
        this.unschedulable = unschedulable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1NodeSpec ioK8sApiCoreV1NodeSpec = (IoK8sApiCoreV1NodeSpec)o;
        return Objects.equals(this.configSource, ioK8sApiCoreV1NodeSpec.configSource) && Objects.equals(this.externalID, ioK8sApiCoreV1NodeSpec.externalID) && Objects.equals(this.podCIDR, ioK8sApiCoreV1NodeSpec.podCIDR) && Objects.equals(this.podCIDRs, ioK8sApiCoreV1NodeSpec.podCIDRs) && Objects.equals(this.providerID, ioK8sApiCoreV1NodeSpec.providerID) && Objects.equals(this.taints, ioK8sApiCoreV1NodeSpec.taints) && Objects.equals(this.unschedulable, ioK8sApiCoreV1NodeSpec.unschedulable);
    }

    public int hashCode() {
        return Objects.hash(this.configSource, this.externalID, this.podCIDR, this.podCIDRs, this.providerID, this.taints, this.unschedulable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1NodeSpec {\n");
        sb.append("    configSource: ").append(this.toIndentedString(this.configSource)).append("\n");
        sb.append("    externalID: ").append(this.toIndentedString(this.externalID)).append("\n");
        sb.append("    podCIDR: ").append(this.toIndentedString(this.podCIDR)).append("\n");
        sb.append("    podCIDRs: ").append(this.toIndentedString(this.podCIDRs)).append("\n");
        sb.append("    providerID: ").append(this.toIndentedString(this.providerID)).append("\n");
        sb.append("    taints: ").append(this.toIndentedString(this.taints)).append("\n");
        sb.append("    unschedulable: ").append(this.toIndentedString(this.unschedulable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

