/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1AttachedVolume;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1ContainerImage;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1NodeAddress;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1NodeCondition;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1NodeConfigStatus;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1NodeDaemonEndpoints;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1NodeSystemInfo;

@ApiModel(description="NodeStatus is information about the current status of a node.")
@JsonPropertyOrder(value={"addresses", "allocatable", "capacity", "conditions", "config", "daemonEndpoints", "images", "nodeInfo", "phase", "volumesAttached", "volumesInUse"})
public class IoK8sApiCoreV1NodeStatus {
    public static final String JSON_PROPERTY_ADDRESSES = "addresses";
    private List<IoK8sApiCoreV1NodeAddress> addresses = null;
    public static final String JSON_PROPERTY_ALLOCATABLE = "allocatable";
    private Map<String, String> allocatable = null;
    public static final String JSON_PROPERTY_CAPACITY = "capacity";
    private Map<String, String> capacity = null;
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private List<IoK8sApiCoreV1NodeCondition> conditions = null;
    public static final String JSON_PROPERTY_CONFIG = "config";
    private IoK8sApiCoreV1NodeConfigStatus config;
    public static final String JSON_PROPERTY_DAEMON_ENDPOINTS = "daemonEndpoints";
    private IoK8sApiCoreV1NodeDaemonEndpoints daemonEndpoints;
    public static final String JSON_PROPERTY_IMAGES = "images";
    private List<IoK8sApiCoreV1ContainerImage> images = null;
    public static final String JSON_PROPERTY_NODE_INFO = "nodeInfo";
    private IoK8sApiCoreV1NodeSystemInfo nodeInfo;
    public static final String JSON_PROPERTY_PHASE = "phase";
    private String phase;
    public static final String JSON_PROPERTY_VOLUMES_ATTACHED = "volumesAttached";
    private List<IoK8sApiCoreV1AttachedVolume> volumesAttached = null;
    public static final String JSON_PROPERTY_VOLUMES_IN_USE = "volumesInUse";
    private List<String> volumesInUse = null;

    public IoK8sApiCoreV1NodeStatus addresses(List<IoK8sApiCoreV1NodeAddress> addresses) {
        this.addresses = addresses;
        return this;
    }

    public IoK8sApiCoreV1NodeStatus addAddressesItem(IoK8sApiCoreV1NodeAddress addressesItem) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<IoK8sApiCoreV1NodeAddress>();
        }
        this.addresses.add(addressesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of addresses reachable to the node. Queried from cloud provider, if available. More info: https://kubernetes.io/docs/concepts/nodes/node/#addresses Note: This field is declared as mergeable, but the merge key is not sufficiently unique, which can cause data corruption when it is merged. Callers should instead use a full-replacement patch. See http://pr.k8s.io/79391 for an example.")
    @JsonProperty(value="addresses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1NodeAddress> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<IoK8sApiCoreV1NodeAddress> addresses) {
        this.addresses = addresses;
    }

    public IoK8sApiCoreV1NodeStatus allocatable(Map<String, String> allocatable) {
        this.allocatable = allocatable;
        return this;
    }

    public IoK8sApiCoreV1NodeStatus putAllocatableItem(String key, String allocatableItem) {
        if (this.allocatable == null) {
            this.allocatable = new HashMap<String, String>();
        }
        this.allocatable.put(key, allocatableItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Allocatable represents the resources of a node that are available for scheduling. Defaults to Capacity.")
    @JsonProperty(value="allocatable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAllocatable() {
        return this.allocatable;
    }

    public void setAllocatable(Map<String, String> allocatable) {
        this.allocatable = allocatable;
    }

    public IoK8sApiCoreV1NodeStatus capacity(Map<String, String> capacity) {
        this.capacity = capacity;
        return this;
    }

    public IoK8sApiCoreV1NodeStatus putCapacityItem(String key, String capacityItem) {
        if (this.capacity == null) {
            this.capacity = new HashMap<String, String>();
        }
        this.capacity.put(key, capacityItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Capacity represents the total resources of a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity")
    @JsonProperty(value="capacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Map<String, String> capacity) {
        this.capacity = capacity;
    }

    public IoK8sApiCoreV1NodeStatus conditions(List<IoK8sApiCoreV1NodeCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public IoK8sApiCoreV1NodeStatus addConditionsItem(IoK8sApiCoreV1NodeCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<IoK8sApiCoreV1NodeCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Conditions is an array of current observed node conditions. More info: https://kubernetes.io/docs/concepts/nodes/node/#condition")
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1NodeCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<IoK8sApiCoreV1NodeCondition> conditions) {
        this.conditions = conditions;
    }

    public IoK8sApiCoreV1NodeStatus config(IoK8sApiCoreV1NodeConfigStatus config) {
        this.config = config;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1NodeConfigStatus getConfig() {
        return this.config;
    }

    public void setConfig(IoK8sApiCoreV1NodeConfigStatus config) {
        this.config = config;
    }

    public IoK8sApiCoreV1NodeStatus daemonEndpoints(IoK8sApiCoreV1NodeDaemonEndpoints daemonEndpoints) {
        this.daemonEndpoints = daemonEndpoints;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="daemonEndpoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1NodeDaemonEndpoints getDaemonEndpoints() {
        return this.daemonEndpoints;
    }

    public void setDaemonEndpoints(IoK8sApiCoreV1NodeDaemonEndpoints daemonEndpoints) {
        this.daemonEndpoints = daemonEndpoints;
    }

    public IoK8sApiCoreV1NodeStatus images(List<IoK8sApiCoreV1ContainerImage> images) {
        this.images = images;
        return this;
    }

    public IoK8sApiCoreV1NodeStatus addImagesItem(IoK8sApiCoreV1ContainerImage imagesItem) {
        if (this.images == null) {
            this.images = new ArrayList<IoK8sApiCoreV1ContainerImage>();
        }
        this.images.add(imagesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of container images on this node")
    @JsonProperty(value="images")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1ContainerImage> getImages() {
        return this.images;
    }

    public void setImages(List<IoK8sApiCoreV1ContainerImage> images) {
        this.images = images;
    }

    public IoK8sApiCoreV1NodeStatus nodeInfo(IoK8sApiCoreV1NodeSystemInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="nodeInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1NodeSystemInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public void setNodeInfo(IoK8sApiCoreV1NodeSystemInfo nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    public IoK8sApiCoreV1NodeStatus phase(String phase) {
        this.phase = phase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NodePhase is the recently observed lifecycle phase of the node. More info: https://kubernetes.io/docs/concepts/nodes/node/#phase The field is never populated, and now is deprecated.")
    @JsonProperty(value="phase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public IoK8sApiCoreV1NodeStatus volumesAttached(List<IoK8sApiCoreV1AttachedVolume> volumesAttached) {
        this.volumesAttached = volumesAttached;
        return this;
    }

    public IoK8sApiCoreV1NodeStatus addVolumesAttachedItem(IoK8sApiCoreV1AttachedVolume volumesAttachedItem) {
        if (this.volumesAttached == null) {
            this.volumesAttached = new ArrayList<IoK8sApiCoreV1AttachedVolume>();
        }
        this.volumesAttached.add(volumesAttachedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of volumes that are attached to the node.")
    @JsonProperty(value="volumesAttached")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1AttachedVolume> getVolumesAttached() {
        return this.volumesAttached;
    }

    public void setVolumesAttached(List<IoK8sApiCoreV1AttachedVolume> volumesAttached) {
        this.volumesAttached = volumesAttached;
    }

    public IoK8sApiCoreV1NodeStatus volumesInUse(List<String> volumesInUse) {
        this.volumesInUse = volumesInUse;
        return this;
    }

    public IoK8sApiCoreV1NodeStatus addVolumesInUseItem(String volumesInUseItem) {
        if (this.volumesInUse == null) {
            this.volumesInUse = new ArrayList<String>();
        }
        this.volumesInUse.add(volumesInUseItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of attachable volumes in use (mounted) by the node.")
    @JsonProperty(value="volumesInUse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getVolumesInUse() {
        return this.volumesInUse;
    }

    public void setVolumesInUse(List<String> volumesInUse) {
        this.volumesInUse = volumesInUse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1NodeStatus ioK8sApiCoreV1NodeStatus = (IoK8sApiCoreV1NodeStatus)o;
        return Objects.equals(this.addresses, ioK8sApiCoreV1NodeStatus.addresses) && Objects.equals(this.allocatable, ioK8sApiCoreV1NodeStatus.allocatable) && Objects.equals(this.capacity, ioK8sApiCoreV1NodeStatus.capacity) && Objects.equals(this.conditions, ioK8sApiCoreV1NodeStatus.conditions) && Objects.equals(this.config, ioK8sApiCoreV1NodeStatus.config) && Objects.equals(this.daemonEndpoints, ioK8sApiCoreV1NodeStatus.daemonEndpoints) && Objects.equals(this.images, ioK8sApiCoreV1NodeStatus.images) && Objects.equals(this.nodeInfo, ioK8sApiCoreV1NodeStatus.nodeInfo) && Objects.equals(this.phase, ioK8sApiCoreV1NodeStatus.phase) && Objects.equals(this.volumesAttached, ioK8sApiCoreV1NodeStatus.volumesAttached) && Objects.equals(this.volumesInUse, ioK8sApiCoreV1NodeStatus.volumesInUse);
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.allocatable, this.capacity, this.conditions, this.config, this.daemonEndpoints, this.images, this.nodeInfo, this.phase, this.volumesAttached, this.volumesInUse);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1NodeStatus {\n");
        sb.append("    addresses: ").append(this.toIndentedString(this.addresses)).append("\n");
        sb.append("    allocatable: ").append(this.toIndentedString(this.allocatable)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    daemonEndpoints: ").append(this.toIndentedString(this.daemonEndpoints)).append("\n");
        sb.append("    images: ").append(this.toIndentedString(this.images)).append("\n");
        sb.append("    nodeInfo: ").append(this.toIndentedString(this.nodeInfo)).append("\n");
        sb.append("    phase: ").append(this.toIndentedString(this.phase)).append("\n");
        sb.append("    volumesAttached: ").append(this.toIndentedString(this.volumesAttached)).append("\n");
        sb.append("    volumesInUse: ").append(this.toIndentedString(this.volumesInUse)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

