/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="NodeSystemInfo is a set of ids/uuids to uniquely identify the node.")
@JsonPropertyOrder(value={"architecture", "bootID", "containerRuntimeVersion", "kernelVersion", "kubeProxyVersion", "kubeletVersion", "machineID", "operatingSystem", "osImage", "systemUUID"})
public class IoK8sApiCoreV1NodeSystemInfo {
    public static final String JSON_PROPERTY_ARCHITECTURE = "architecture";
    private String architecture;
    public static final String JSON_PROPERTY_BOOT_I_D = "bootID";
    private String bootID;
    public static final String JSON_PROPERTY_CONTAINER_RUNTIME_VERSION = "containerRuntimeVersion";
    private String containerRuntimeVersion;
    public static final String JSON_PROPERTY_KERNEL_VERSION = "kernelVersion";
    private String kernelVersion;
    public static final String JSON_PROPERTY_KUBE_PROXY_VERSION = "kubeProxyVersion";
    private String kubeProxyVersion;
    public static final String JSON_PROPERTY_KUBELET_VERSION = "kubeletVersion";
    private String kubeletVersion;
    public static final String JSON_PROPERTY_MACHINE_I_D = "machineID";
    private String machineID;
    public static final String JSON_PROPERTY_OPERATING_SYSTEM = "operatingSystem";
    private String operatingSystem;
    public static final String JSON_PROPERTY_OS_IMAGE = "osImage";
    private String osImage;
    public static final String JSON_PROPERTY_SYSTEM_U_U_I_D = "systemUUID";
    private String systemUUID;

    public IoK8sApiCoreV1NodeSystemInfo architecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    @ApiModelProperty(required=true, value="The Architecture reported by the node")
    @JsonProperty(value="architecture")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public IoK8sApiCoreV1NodeSystemInfo bootID(String bootID) {
        this.bootID = bootID;
        return this;
    }

    @ApiModelProperty(required=true, value="Boot ID reported by the node.")
    @JsonProperty(value="bootID")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBootID() {
        return this.bootID;
    }

    public void setBootID(String bootID) {
        this.bootID = bootID;
    }

    public IoK8sApiCoreV1NodeSystemInfo containerRuntimeVersion(String containerRuntimeVersion) {
        this.containerRuntimeVersion = containerRuntimeVersion;
        return this;
    }

    @ApiModelProperty(required=true, value="ContainerRuntime Version reported by the node through runtime remote API (e.g. docker://1.5.0).")
    @JsonProperty(value="containerRuntimeVersion")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getContainerRuntimeVersion() {
        return this.containerRuntimeVersion;
    }

    public void setContainerRuntimeVersion(String containerRuntimeVersion) {
        this.containerRuntimeVersion = containerRuntimeVersion;
    }

    public IoK8sApiCoreV1NodeSystemInfo kernelVersion(String kernelVersion) {
        this.kernelVersion = kernelVersion;
        return this;
    }

    @ApiModelProperty(required=true, value="Kernel Version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64).")
    @JsonProperty(value="kernelVersion")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getKernelVersion() {
        return this.kernelVersion;
    }

    public void setKernelVersion(String kernelVersion) {
        this.kernelVersion = kernelVersion;
    }

    public IoK8sApiCoreV1NodeSystemInfo kubeProxyVersion(String kubeProxyVersion) {
        this.kubeProxyVersion = kubeProxyVersion;
        return this;
    }

    @ApiModelProperty(required=true, value="KubeProxy Version reported by the node.")
    @JsonProperty(value="kubeProxyVersion")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getKubeProxyVersion() {
        return this.kubeProxyVersion;
    }

    public void setKubeProxyVersion(String kubeProxyVersion) {
        this.kubeProxyVersion = kubeProxyVersion;
    }

    public IoK8sApiCoreV1NodeSystemInfo kubeletVersion(String kubeletVersion) {
        this.kubeletVersion = kubeletVersion;
        return this;
    }

    @ApiModelProperty(required=true, value="Kubelet Version reported by the node.")
    @JsonProperty(value="kubeletVersion")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getKubeletVersion() {
        return this.kubeletVersion;
    }

    public void setKubeletVersion(String kubeletVersion) {
        this.kubeletVersion = kubeletVersion;
    }

    public IoK8sApiCoreV1NodeSystemInfo machineID(String machineID) {
        this.machineID = machineID;
        return this;
    }

    @ApiModelProperty(required=true, value="MachineID reported by the node. For unique machine identification in the cluster this field is preferred. Learn more from man(5) machine-id: http://man7.org/linux/man-pages/man5/machine-id.5.html")
    @JsonProperty(value="machineID")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMachineID() {
        return this.machineID;
    }

    public void setMachineID(String machineID) {
        this.machineID = machineID;
    }

    public IoK8sApiCoreV1NodeSystemInfo operatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
        return this;
    }

    @ApiModelProperty(required=true, value="The Operating System reported by the node")
    @JsonProperty(value="operatingSystem")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public void setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public IoK8sApiCoreV1NodeSystemInfo osImage(String osImage) {
        this.osImage = osImage;
        return this;
    }

    @ApiModelProperty(required=true, value="OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy)).")
    @JsonProperty(value="osImage")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOsImage() {
        return this.osImage;
    }

    public void setOsImage(String osImage) {
        this.osImage = osImage;
    }

    public IoK8sApiCoreV1NodeSystemInfo systemUUID(String systemUUID) {
        this.systemUUID = systemUUID;
        return this;
    }

    @ApiModelProperty(required=true, value="SystemUUID reported by the node. For unique machine identification MachineID is preferred. This field is specific to Red Hat hosts https://access.redhat.com/documentation/en-US/Red_Hat_Subscription_Management/1/html/RHSM/getting-system-uuid.html")
    @JsonProperty(value="systemUUID")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSystemUUID() {
        return this.systemUUID;
    }

    public void setSystemUUID(String systemUUID) {
        this.systemUUID = systemUUID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1NodeSystemInfo ioK8sApiCoreV1NodeSystemInfo = (IoK8sApiCoreV1NodeSystemInfo)o;
        return Objects.equals(this.architecture, ioK8sApiCoreV1NodeSystemInfo.architecture) && Objects.equals(this.bootID, ioK8sApiCoreV1NodeSystemInfo.bootID) && Objects.equals(this.containerRuntimeVersion, ioK8sApiCoreV1NodeSystemInfo.containerRuntimeVersion) && Objects.equals(this.kernelVersion, ioK8sApiCoreV1NodeSystemInfo.kernelVersion) && Objects.equals(this.kubeProxyVersion, ioK8sApiCoreV1NodeSystemInfo.kubeProxyVersion) && Objects.equals(this.kubeletVersion, ioK8sApiCoreV1NodeSystemInfo.kubeletVersion) && Objects.equals(this.machineID, ioK8sApiCoreV1NodeSystemInfo.machineID) && Objects.equals(this.operatingSystem, ioK8sApiCoreV1NodeSystemInfo.operatingSystem) && Objects.equals(this.osImage, ioK8sApiCoreV1NodeSystemInfo.osImage) && Objects.equals(this.systemUUID, ioK8sApiCoreV1NodeSystemInfo.systemUUID);
    }

    public int hashCode() {
        return Objects.hash(this.architecture, this.bootID, this.containerRuntimeVersion, this.kernelVersion, this.kubeProxyVersion, this.kubeletVersion, this.machineID, this.operatingSystem, this.osImage, this.systemUUID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1NodeSystemInfo {\n");
        sb.append("    architecture: ").append(this.toIndentedString(this.architecture)).append("\n");
        sb.append("    bootID: ").append(this.toIndentedString(this.bootID)).append("\n");
        sb.append("    containerRuntimeVersion: ").append(this.toIndentedString(this.containerRuntimeVersion)).append("\n");
        sb.append("    kernelVersion: ").append(this.toIndentedString(this.kernelVersion)).append("\n");
        sb.append("    kubeProxyVersion: ").append(this.toIndentedString(this.kubeProxyVersion)).append("\n");
        sb.append("    kubeletVersion: ").append(this.toIndentedString(this.kubeletVersion)).append("\n");
        sb.append("    machineID: ").append(this.toIndentedString(this.machineID)).append("\n");
        sb.append("    operatingSystem: ").append(this.toIndentedString(this.operatingSystem)).append("\n");
        sb.append("    osImage: ").append(this.toIndentedString(this.osImage)).append("\n");
        sb.append("    systemUUID: ").append(this.toIndentedString(this.systemUUID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

