/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ObjectFieldSelector selects an APIVersioned field of an object.")
@JsonPropertyOrder(value={"apiVersion", "fieldPath"})
public class IoK8sApiCoreV1ObjectFieldSelector {
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    private String apiVersion;
    public static final String JSON_PROPERTY_FIELD_PATH = "fieldPath";
    private String fieldPath;

    public IoK8sApiCoreV1ObjectFieldSelector apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Version of the schema the FieldPath is written in terms of, defaults to \"v1\".")
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public IoK8sApiCoreV1ObjectFieldSelector fieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
        return this;
    }

    @ApiModelProperty(required=true, value="Path of the field to select in the specified API version.")
    @JsonProperty(value="fieldPath")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFieldPath() {
        return this.fieldPath;
    }

    public void setFieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1ObjectFieldSelector ioK8sApiCoreV1ObjectFieldSelector = (IoK8sApiCoreV1ObjectFieldSelector)o;
        return Objects.equals(this.apiVersion, ioK8sApiCoreV1ObjectFieldSelector.apiVersion) && Objects.equals(this.fieldPath, ioK8sApiCoreV1ObjectFieldSelector.fieldPath);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.fieldPath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1ObjectFieldSelector {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    fieldPath: ").append(this.toIndentedString(this.fieldPath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

