/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1ResourceRequirements;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1TypedLocalObjectReference;
import net.stickycode.kuuty.model.v18.IoK8sApimachineryPkgApisMetaV1LabelSelector;

@ApiModel(description="PersistentVolumeClaimSpec describes the common attributes of storage devices and allows a Source for provider-specific attributes")
@JsonPropertyOrder(value={"accessModes", "dataSource", "resources", "selector", "storageClassName", "volumeMode", "volumeName"})
public class IoK8sApiCoreV1PersistentVolumeClaimSpec {
    public static final String JSON_PROPERTY_ACCESS_MODES = "accessModes";
    private List<String> accessModes = null;
    public static final String JSON_PROPERTY_DATA_SOURCE = "dataSource";
    private IoK8sApiCoreV1TypedLocalObjectReference dataSource;
    public static final String JSON_PROPERTY_RESOURCES = "resources";
    private IoK8sApiCoreV1ResourceRequirements resources;
    public static final String JSON_PROPERTY_SELECTOR = "selector";
    private IoK8sApimachineryPkgApisMetaV1LabelSelector selector;
    public static final String JSON_PROPERTY_STORAGE_CLASS_NAME = "storageClassName";
    private String storageClassName;
    public static final String JSON_PROPERTY_VOLUME_MODE = "volumeMode";
    private String volumeMode;
    public static final String JSON_PROPERTY_VOLUME_NAME = "volumeName";
    private String volumeName;

    public IoK8sApiCoreV1PersistentVolumeClaimSpec accessModes(List<String> accessModes) {
        this.accessModes = accessModes;
        return this;
    }

    public IoK8sApiCoreV1PersistentVolumeClaimSpec addAccessModesItem(String accessModesItem) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.add(accessModesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AccessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1")
    @JsonProperty(value="accessModes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    public void setAccessModes(List<String> accessModes) {
        this.accessModes = accessModes;
    }

    public IoK8sApiCoreV1PersistentVolumeClaimSpec dataSource(IoK8sApiCoreV1TypedLocalObjectReference dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="dataSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1TypedLocalObjectReference getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(IoK8sApiCoreV1TypedLocalObjectReference dataSource) {
        this.dataSource = dataSource;
    }

    public IoK8sApiCoreV1PersistentVolumeClaimSpec resources(IoK8sApiCoreV1ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="resources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(IoK8sApiCoreV1ResourceRequirements resources) {
        this.resources = resources;
    }

    public IoK8sApiCoreV1PersistentVolumeClaimSpec selector(IoK8sApimachineryPkgApisMetaV1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="selector")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApimachineryPkgApisMetaV1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(IoK8sApimachineryPkgApisMetaV1LabelSelector selector) {
        this.selector = selector;
    }

    public IoK8sApiCoreV1PersistentVolumeClaimSpec storageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1")
    @JsonProperty(value="storageClassName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStorageClassName() {
        return this.storageClassName;
    }

    public void setStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
    }

    public IoK8sApiCoreV1PersistentVolumeClaimSpec volumeMode(String volumeMode) {
        this.volumeMode = volumeMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec.")
    @JsonProperty(value="volumeMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVolumeMode() {
        return this.volumeMode;
    }

    public void setVolumeMode(String volumeMode) {
        this.volumeMode = volumeMode;
    }

    public IoK8sApiCoreV1PersistentVolumeClaimSpec volumeName(String volumeName) {
        this.volumeName = volumeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="VolumeName is the binding reference to the PersistentVolume backing this claim.")
    @JsonProperty(value="volumeName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1PersistentVolumeClaimSpec ioK8sApiCoreV1PersistentVolumeClaimSpec = (IoK8sApiCoreV1PersistentVolumeClaimSpec)o;
        return Objects.equals(this.accessModes, ioK8sApiCoreV1PersistentVolumeClaimSpec.accessModes) && Objects.equals(this.dataSource, ioK8sApiCoreV1PersistentVolumeClaimSpec.dataSource) && Objects.equals(this.resources, ioK8sApiCoreV1PersistentVolumeClaimSpec.resources) && Objects.equals(this.selector, ioK8sApiCoreV1PersistentVolumeClaimSpec.selector) && Objects.equals(this.storageClassName, ioK8sApiCoreV1PersistentVolumeClaimSpec.storageClassName) && Objects.equals(this.volumeMode, ioK8sApiCoreV1PersistentVolumeClaimSpec.volumeMode) && Objects.equals(this.volumeName, ioK8sApiCoreV1PersistentVolumeClaimSpec.volumeName);
    }

    public int hashCode() {
        return Objects.hash(this.accessModes, this.dataSource, this.resources, this.selector, this.storageClassName, this.volumeMode, this.volumeName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1PersistentVolumeClaimSpec {\n");
        sb.append("    accessModes: ").append(this.toIndentedString(this.accessModes)).append("\n");
        sb.append("    dataSource: ").append(this.toIndentedString(this.dataSource)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    storageClassName: ").append(this.toIndentedString(this.storageClassName)).append("\n");
        sb.append("    volumeMode: ").append(this.toIndentedString(this.volumeMode)).append("\n");
        sb.append("    volumeName: ").append(this.toIndentedString(this.volumeName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

