/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1PersistentVolumeClaimCondition;

@ApiModel(description="PersistentVolumeClaimStatus is the current status of a persistent volume claim.")
@JsonPropertyOrder(value={"accessModes", "capacity", "conditions", "phase"})
public class IoK8sApiCoreV1PersistentVolumeClaimStatus {
    public static final String JSON_PROPERTY_ACCESS_MODES = "accessModes";
    private List<String> accessModes = null;
    public static final String JSON_PROPERTY_CAPACITY = "capacity";
    private Map<String, String> capacity = null;
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private List<IoK8sApiCoreV1PersistentVolumeClaimCondition> conditions = null;
    public static final String JSON_PROPERTY_PHASE = "phase";
    private String phase;

    public IoK8sApiCoreV1PersistentVolumeClaimStatus accessModes(List<String> accessModes) {
        this.accessModes = accessModes;
        return this;
    }

    public IoK8sApiCoreV1PersistentVolumeClaimStatus addAccessModesItem(String accessModesItem) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.add(accessModesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AccessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1")
    @JsonProperty(value="accessModes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    public void setAccessModes(List<String> accessModes) {
        this.accessModes = accessModes;
    }

    public IoK8sApiCoreV1PersistentVolumeClaimStatus capacity(Map<String, String> capacity) {
        this.capacity = capacity;
        return this;
    }

    public IoK8sApiCoreV1PersistentVolumeClaimStatus putCapacityItem(String key, String capacityItem) {
        if (this.capacity == null) {
            this.capacity = new HashMap<String, String>();
        }
        this.capacity.put(key, capacityItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the actual resources of the underlying volume.")
    @JsonProperty(value="capacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getCapacity() {
        return this.capacity;
    }

    public void setCapacity(Map<String, String> capacity) {
        this.capacity = capacity;
    }

    public IoK8sApiCoreV1PersistentVolumeClaimStatus conditions(List<IoK8sApiCoreV1PersistentVolumeClaimCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public IoK8sApiCoreV1PersistentVolumeClaimStatus addConditionsItem(IoK8sApiCoreV1PersistentVolumeClaimCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<IoK8sApiCoreV1PersistentVolumeClaimCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to 'ResizeStarted'.")
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1PersistentVolumeClaimCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<IoK8sApiCoreV1PersistentVolumeClaimCondition> conditions) {
        this.conditions = conditions;
    }

    public IoK8sApiCoreV1PersistentVolumeClaimStatus phase(String phase) {
        this.phase = phase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Phase represents the current phase of PersistentVolumeClaim.")
    @JsonProperty(value="phase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1PersistentVolumeClaimStatus ioK8sApiCoreV1PersistentVolumeClaimStatus = (IoK8sApiCoreV1PersistentVolumeClaimStatus)o;
        return Objects.equals(this.accessModes, ioK8sApiCoreV1PersistentVolumeClaimStatus.accessModes) && Objects.equals(this.capacity, ioK8sApiCoreV1PersistentVolumeClaimStatus.capacity) && Objects.equals(this.conditions, ioK8sApiCoreV1PersistentVolumeClaimStatus.conditions) && Objects.equals(this.phase, ioK8sApiCoreV1PersistentVolumeClaimStatus.phase);
    }

    public int hashCode() {
        return Objects.hash(this.accessModes, this.capacity, this.conditions, this.phase);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1PersistentVolumeClaimStatus {\n");
        sb.append("    accessModes: ").append(this.toIndentedString(this.accessModes)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    phase: ").append(this.toIndentedString(this.phase)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

