/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApimachineryPkgApisMetaV1LabelSelector;

@ApiModel(description="Defines a set of pods (namely those matching the labelSelector relative to the given namespace(s)) that this pod should be co-located (affinity) or not co-located (anti-affinity) with, where co-located is defined as running on a node whose value of the label with key <topologyKey> matches that of any node on which a pod of the set of pods is running")
@JsonPropertyOrder(value={"labelSelector", "namespaces", "topologyKey"})
public class IoK8sApiCoreV1PodAffinityTerm {
    public static final String JSON_PROPERTY_LABEL_SELECTOR = "labelSelector";
    private IoK8sApimachineryPkgApisMetaV1LabelSelector labelSelector;
    public static final String JSON_PROPERTY_NAMESPACES = "namespaces";
    private List<String> namespaces = null;
    public static final String JSON_PROPERTY_TOPOLOGY_KEY = "topologyKey";
    private String topologyKey;

    public IoK8sApiCoreV1PodAffinityTerm labelSelector(IoK8sApimachineryPkgApisMetaV1LabelSelector labelSelector) {
        this.labelSelector = labelSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="labelSelector")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApimachineryPkgApisMetaV1LabelSelector getLabelSelector() {
        return this.labelSelector;
    }

    public void setLabelSelector(IoK8sApimachineryPkgApisMetaV1LabelSelector labelSelector) {
        this.labelSelector = labelSelector;
    }

    public IoK8sApiCoreV1PodAffinityTerm namespaces(List<String> namespaces) {
        this.namespaces = namespaces;
        return this;
    }

    public IoK8sApiCoreV1PodAffinityTerm addNamespacesItem(String namespacesItem) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.add(namespacesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means \"this pod's namespace\"")
    @JsonProperty(value="namespaces")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(List<String> namespaces) {
        this.namespaces = namespaces;
    }

    public IoK8sApiCoreV1PodAffinityTerm topologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
        return this;
    }

    @ApiModelProperty(required=true, value="This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching the labelSelector in the specified namespaces, where co-located is defined as running on a node whose value of the label with key topologyKey matches that of any node on which any of the selected pods is running. Empty topologyKey is not allowed.")
    @JsonProperty(value="topologyKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTopologyKey() {
        return this.topologyKey;
    }

    public void setTopologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1PodAffinityTerm ioK8sApiCoreV1PodAffinityTerm = (IoK8sApiCoreV1PodAffinityTerm)o;
        return Objects.equals(this.labelSelector, ioK8sApiCoreV1PodAffinityTerm.labelSelector) && Objects.equals(this.namespaces, ioK8sApiCoreV1PodAffinityTerm.namespaces) && Objects.equals(this.topologyKey, ioK8sApiCoreV1PodAffinityTerm.topologyKey);
    }

    public int hashCode() {
        return Objects.hash(this.labelSelector, this.namespaces, this.topologyKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1PodAffinityTerm {\n");
        sb.append("    labelSelector: ").append(this.toIndentedString(this.labelSelector)).append("\n");
        sb.append("    namespaces: ").append(this.toIndentedString(this.namespaces)).append("\n");
        sb.append("    topologyKey: ").append(this.toIndentedString(this.topologyKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

