/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1PodDNSConfigOption;

@ApiModel(description="PodDNSConfig defines the DNS parameters of a pod in addition to those generated from DNSPolicy.")
@JsonPropertyOrder(value={"nameservers", "options", "searches"})
public class IoK8sApiCoreV1PodDNSConfig {
    public static final String JSON_PROPERTY_NAMESERVERS = "nameservers";
    private List<String> nameservers = null;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private List<IoK8sApiCoreV1PodDNSConfigOption> options = null;
    public static final String JSON_PROPERTY_SEARCHES = "searches";
    private List<String> searches = null;

    public IoK8sApiCoreV1PodDNSConfig nameservers(List<String> nameservers) {
        this.nameservers = nameservers;
        return this;
    }

    public IoK8sApiCoreV1PodDNSConfig addNameserversItem(String nameserversItem) {
        if (this.nameservers == null) {
            this.nameservers = new ArrayList<String>();
        }
        this.nameservers.add(nameserversItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed.")
    @JsonProperty(value="nameservers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getNameservers() {
        return this.nameservers;
    }

    public void setNameservers(List<String> nameservers) {
        this.nameservers = nameservers;
    }

    public IoK8sApiCoreV1PodDNSConfig options(List<IoK8sApiCoreV1PodDNSConfigOption> options) {
        this.options = options;
        return this;
    }

    public IoK8sApiCoreV1PodDNSConfig addOptionsItem(IoK8sApiCoreV1PodDNSConfigOption optionsItem) {
        if (this.options == null) {
            this.options = new ArrayList<IoK8sApiCoreV1PodDNSConfigOption>();
        }
        this.options.add(optionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy.")
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1PodDNSConfigOption> getOptions() {
        return this.options;
    }

    public void setOptions(List<IoK8sApiCoreV1PodDNSConfigOption> options) {
        this.options = options;
    }

    public IoK8sApiCoreV1PodDNSConfig searches(List<String> searches) {
        this.searches = searches;
        return this;
    }

    public IoK8sApiCoreV1PodDNSConfig addSearchesItem(String searchesItem) {
        if (this.searches == null) {
            this.searches = new ArrayList<String>();
        }
        this.searches.add(searchesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed.")
    @JsonProperty(value="searches")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSearches() {
        return this.searches;
    }

    public void setSearches(List<String> searches) {
        this.searches = searches;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1PodDNSConfig ioK8sApiCoreV1PodDNSConfig = (IoK8sApiCoreV1PodDNSConfig)o;
        return Objects.equals(this.nameservers, ioK8sApiCoreV1PodDNSConfig.nameservers) && Objects.equals(this.options, ioK8sApiCoreV1PodDNSConfig.options) && Objects.equals(this.searches, ioK8sApiCoreV1PodDNSConfig.searches);
    }

    public int hashCode() {
        return Objects.hash(this.nameservers, this.options, this.searches);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1PodDNSConfig {\n");
        sb.append("    nameservers: ").append(this.toIndentedString(this.nameservers)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    searches: ").append(this.toIndentedString(this.searches)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

