/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1SELinuxOptions;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1Sysctl;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1WindowsSecurityContextOptions;

@ApiModel(description="PodSecurityContext holds pod-level security attributes and common container settings. Some fields are also present in container.securityContext.  Field values of container.securityContext take precedence over field values of PodSecurityContext.")
@JsonPropertyOrder(value={"fsGroup", "fsGroupChangePolicy", "runAsGroup", "runAsNonRoot", "runAsUser", "seLinuxOptions", "supplementalGroups", "sysctls", "windowsOptions"})
public class IoK8sApiCoreV1PodSecurityContext {
    public static final String JSON_PROPERTY_FS_GROUP = "fsGroup";
    private Long fsGroup;
    public static final String JSON_PROPERTY_FS_GROUP_CHANGE_POLICY = "fsGroupChangePolicy";
    private String fsGroupChangePolicy;
    public static final String JSON_PROPERTY_RUN_AS_GROUP = "runAsGroup";
    private Long runAsGroup;
    public static final String JSON_PROPERTY_RUN_AS_NON_ROOT = "runAsNonRoot";
    private Boolean runAsNonRoot;
    public static final String JSON_PROPERTY_RUN_AS_USER = "runAsUser";
    private Long runAsUser;
    public static final String JSON_PROPERTY_SE_LINUX_OPTIONS = "seLinuxOptions";
    private IoK8sApiCoreV1SELinuxOptions seLinuxOptions;
    public static final String JSON_PROPERTY_SUPPLEMENTAL_GROUPS = "supplementalGroups";
    private List<Long> supplementalGroups = null;
    public static final String JSON_PROPERTY_SYSCTLS = "sysctls";
    private List<IoK8sApiCoreV1Sysctl> sysctls = null;
    public static final String JSON_PROPERTY_WINDOWS_OPTIONS = "windowsOptions";
    private IoK8sApiCoreV1WindowsSecurityContextOptions windowsOptions;

    public IoK8sApiCoreV1PodSecurityContext fsGroup(Long fsGroup) {
        this.fsGroup = fsGroup;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod:  1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw----  If unset, the Kubelet will not modify the ownership and permissions of any volume.")
    @JsonProperty(value="fsGroup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getFsGroup() {
        return this.fsGroup;
    }

    public void setFsGroup(Long fsGroup) {
        this.fsGroup = fsGroup;
    }

    public IoK8sApiCoreV1PodSecurityContext fsGroupChangePolicy(String fsGroupChangePolicy) {
        this.fsGroupChangePolicy = fsGroupChangePolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="fsGroupChangePolicy defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir. Valid values are \"OnRootMismatch\" and \"Always\". If not specified defaults to \"Always\".")
    @JsonProperty(value="fsGroupChangePolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFsGroupChangePolicy() {
        return this.fsGroupChangePolicy;
    }

    public void setFsGroupChangePolicy(String fsGroupChangePolicy) {
        this.fsGroupChangePolicy = fsGroupChangePolicy;
    }

    public IoK8sApiCoreV1PodSecurityContext runAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.")
    @JsonProperty(value="runAsGroup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    public void setRunAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
    }

    public IoK8sApiCoreV1PodSecurityContext runAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.")
    @JsonProperty(value="runAsNonRoot")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public void setRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
    }

    public IoK8sApiCoreV1PodSecurityContext runAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.")
    @JsonProperty(value="runAsUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public void setRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
    }

    public IoK8sApiCoreV1PodSecurityContext seLinuxOptions(IoK8sApiCoreV1SELinuxOptions seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="seLinuxOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions;
    }

    public void setSeLinuxOptions(IoK8sApiCoreV1SELinuxOptions seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
    }

    public IoK8sApiCoreV1PodSecurityContext supplementalGroups(List<Long> supplementalGroups) {
        this.supplementalGroups = supplementalGroups;
        return this;
    }

    public IoK8sApiCoreV1PodSecurityContext addSupplementalGroupsItem(Long supplementalGroupsItem) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        this.supplementalGroups.add(supplementalGroupsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of groups applied to the first process run in each container, in addition to the container's primary GID.  If unspecified, no groups will be added to any container.")
    @JsonProperty(value="supplementalGroups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Long> getSupplementalGroups() {
        return this.supplementalGroups;
    }

    public void setSupplementalGroups(List<Long> supplementalGroups) {
        this.supplementalGroups = supplementalGroups;
    }

    public IoK8sApiCoreV1PodSecurityContext sysctls(List<IoK8sApiCoreV1Sysctl> sysctls) {
        this.sysctls = sysctls;
        return this;
    }

    public IoK8sApiCoreV1PodSecurityContext addSysctlsItem(IoK8sApiCoreV1Sysctl sysctlsItem) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList<IoK8sApiCoreV1Sysctl>();
        }
        this.sysctls.add(sysctlsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch.")
    @JsonProperty(value="sysctls")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1Sysctl> getSysctls() {
        return this.sysctls;
    }

    public void setSysctls(List<IoK8sApiCoreV1Sysctl> sysctls) {
        this.sysctls = sysctls;
    }

    public IoK8sApiCoreV1PodSecurityContext windowsOptions(IoK8sApiCoreV1WindowsSecurityContextOptions windowsOptions) {
        this.windowsOptions = windowsOptions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="windowsOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1WindowsSecurityContextOptions getWindowsOptions() {
        return this.windowsOptions;
    }

    public void setWindowsOptions(IoK8sApiCoreV1WindowsSecurityContextOptions windowsOptions) {
        this.windowsOptions = windowsOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1PodSecurityContext ioK8sApiCoreV1PodSecurityContext = (IoK8sApiCoreV1PodSecurityContext)o;
        return Objects.equals(this.fsGroup, ioK8sApiCoreV1PodSecurityContext.fsGroup) && Objects.equals(this.fsGroupChangePolicy, ioK8sApiCoreV1PodSecurityContext.fsGroupChangePolicy) && Objects.equals(this.runAsGroup, ioK8sApiCoreV1PodSecurityContext.runAsGroup) && Objects.equals(this.runAsNonRoot, ioK8sApiCoreV1PodSecurityContext.runAsNonRoot) && Objects.equals(this.runAsUser, ioK8sApiCoreV1PodSecurityContext.runAsUser) && Objects.equals(this.seLinuxOptions, ioK8sApiCoreV1PodSecurityContext.seLinuxOptions) && Objects.equals(this.supplementalGroups, ioK8sApiCoreV1PodSecurityContext.supplementalGroups) && Objects.equals(this.sysctls, ioK8sApiCoreV1PodSecurityContext.sysctls) && Objects.equals(this.windowsOptions, ioK8sApiCoreV1PodSecurityContext.windowsOptions);
    }

    public int hashCode() {
        return Objects.hash(this.fsGroup, this.fsGroupChangePolicy, this.runAsGroup, this.runAsNonRoot, this.runAsUser, this.seLinuxOptions, this.supplementalGroups, this.sysctls, this.windowsOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1PodSecurityContext {\n");
        sb.append("    fsGroup: ").append(this.toIndentedString(this.fsGroup)).append("\n");
        sb.append("    fsGroupChangePolicy: ").append(this.toIndentedString(this.fsGroupChangePolicy)).append("\n");
        sb.append("    runAsGroup: ").append(this.toIndentedString(this.runAsGroup)).append("\n");
        sb.append("    runAsNonRoot: ").append(this.toIndentedString(this.runAsNonRoot)).append("\n");
        sb.append("    runAsUser: ").append(this.toIndentedString(this.runAsUser)).append("\n");
        sb.append("    seLinuxOptions: ").append(this.toIndentedString(this.seLinuxOptions)).append("\n");
        sb.append("    supplementalGroups: ").append(this.toIndentedString(this.supplementalGroups)).append("\n");
        sb.append("    sysctls: ").append(this.toIndentedString(this.sysctls)).append("\n");
        sb.append("    windowsOptions: ").append(this.toIndentedString(this.windowsOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

