/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1ContainerStatus;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1PodCondition;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1PodIP;

@ApiModel(description="PodStatus represents information about the status of a pod. Status may trail the actual state of a system, especially if the node that hosts the pod cannot contact the control plane.")
@JsonPropertyOrder(value={"conditions", "containerStatuses", "ephemeralContainerStatuses", "hostIP", "initContainerStatuses", "message", "nominatedNodeName", "phase", "podIP", "podIPs", "qosClass", "reason", "startTime"})
public class IoK8sApiCoreV1PodStatus {
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private List<IoK8sApiCoreV1PodCondition> conditions = null;
    public static final String JSON_PROPERTY_CONTAINER_STATUSES = "containerStatuses";
    private List<IoK8sApiCoreV1ContainerStatus> containerStatuses = null;
    public static final String JSON_PROPERTY_EPHEMERAL_CONTAINER_STATUSES = "ephemeralContainerStatuses";
    private List<IoK8sApiCoreV1ContainerStatus> ephemeralContainerStatuses = null;
    public static final String JSON_PROPERTY_HOST_I_P = "hostIP";
    private String hostIP;
    public static final String JSON_PROPERTY_INIT_CONTAINER_STATUSES = "initContainerStatuses";
    private List<IoK8sApiCoreV1ContainerStatus> initContainerStatuses = null;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_NOMINATED_NODE_NAME = "nominatedNodeName";
    private String nominatedNodeName;
    public static final String JSON_PROPERTY_PHASE = "phase";
    private String phase;
    public static final String JSON_PROPERTY_POD_I_P = "podIP";
    private String podIP;
    public static final String JSON_PROPERTY_POD_I_PS = "podIPs";
    private List<IoK8sApiCoreV1PodIP> podIPs = null;
    public static final String JSON_PROPERTY_QOS_CLASS = "qosClass";
    private String qosClass;
    public static final String JSON_PROPERTY_REASON = "reason";
    private String reason;
    public static final String JSON_PROPERTY_START_TIME = "startTime";
    private OffsetDateTime startTime;

    public IoK8sApiCoreV1PodStatus conditions(List<IoK8sApiCoreV1PodCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public IoK8sApiCoreV1PodStatus addConditionsItem(IoK8sApiCoreV1PodCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<IoK8sApiCoreV1PodCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Current service state of pod. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions")
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1PodCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<IoK8sApiCoreV1PodCondition> conditions) {
        this.conditions = conditions;
    }

    public IoK8sApiCoreV1PodStatus containerStatuses(List<IoK8sApiCoreV1ContainerStatus> containerStatuses) {
        this.containerStatuses = containerStatuses;
        return this;
    }

    public IoK8sApiCoreV1PodStatus addContainerStatusesItem(IoK8sApiCoreV1ContainerStatus containerStatusesItem) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList<IoK8sApiCoreV1ContainerStatus>();
        }
        this.containerStatuses.add(containerStatusesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list has one entry per container in the manifest. Each entry is currently the output of `docker inspect`. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status")
    @JsonProperty(value="containerStatuses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1ContainerStatus> getContainerStatuses() {
        return this.containerStatuses;
    }

    public void setContainerStatuses(List<IoK8sApiCoreV1ContainerStatus> containerStatuses) {
        this.containerStatuses = containerStatuses;
    }

    public IoK8sApiCoreV1PodStatus ephemeralContainerStatuses(List<IoK8sApiCoreV1ContainerStatus> ephemeralContainerStatuses) {
        this.ephemeralContainerStatuses = ephemeralContainerStatuses;
        return this;
    }

    public IoK8sApiCoreV1PodStatus addEphemeralContainerStatusesItem(IoK8sApiCoreV1ContainerStatus ephemeralContainerStatusesItem) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList<IoK8sApiCoreV1ContainerStatus>();
        }
        this.ephemeralContainerStatuses.add(ephemeralContainerStatusesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Status for any ephemeral containers that have run in this pod. This field is alpha-level and is only populated by servers that enable the EphemeralContainers feature.")
    @JsonProperty(value="ephemeralContainerStatuses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1ContainerStatus> getEphemeralContainerStatuses() {
        return this.ephemeralContainerStatuses;
    }

    public void setEphemeralContainerStatuses(List<IoK8sApiCoreV1ContainerStatus> ephemeralContainerStatuses) {
        this.ephemeralContainerStatuses = ephemeralContainerStatuses;
    }

    public IoK8sApiCoreV1PodStatus hostIP(String hostIP) {
        this.hostIP = hostIP;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IP address of the host to which the pod is assigned. Empty if not yet scheduled.")
    @JsonProperty(value="hostIP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHostIP() {
        return this.hostIP;
    }

    public void setHostIP(String hostIP) {
        this.hostIP = hostIP;
    }

    public IoK8sApiCoreV1PodStatus initContainerStatuses(List<IoK8sApiCoreV1ContainerStatus> initContainerStatuses) {
        this.initContainerStatuses = initContainerStatuses;
        return this;
    }

    public IoK8sApiCoreV1PodStatus addInitContainerStatusesItem(IoK8sApiCoreV1ContainerStatus initContainerStatusesItem) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList<IoK8sApiCoreV1ContainerStatus>();
        }
        this.initContainerStatuses.add(initContainerStatusesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list has one entry per init container in the manifest. The most recent successful init container will have ready = true, the most recently started container will have startTime set. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status")
    @JsonProperty(value="initContainerStatuses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1ContainerStatus> getInitContainerStatuses() {
        return this.initContainerStatuses;
    }

    public void setInitContainerStatuses(List<IoK8sApiCoreV1ContainerStatus> initContainerStatuses) {
        this.initContainerStatuses = initContainerStatuses;
    }

    public IoK8sApiCoreV1PodStatus message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A human readable message indicating details about why the pod is in this condition.")
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public IoK8sApiCoreV1PodStatus nominatedNodeName(String nominatedNodeName) {
        this.nominatedNodeName = nominatedNodeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="nominatedNodeName is set only when this pod preempts other pods on the node, but it cannot be scheduled right away as preemption victims receive their graceful termination periods. This field does not guarantee that the pod will be scheduled on this node. Scheduler may decide to place the pod elsewhere if other nodes become available sooner. Scheduler may also decide to give the resources on this node to a higher priority pod that is created after preemption. As a result, this field may be different than PodSpec.nodeName when the pod is scheduled.")
    @JsonProperty(value="nominatedNodeName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNominatedNodeName() {
        return this.nominatedNodeName;
    }

    public void setNominatedNodeName(String nominatedNodeName) {
        this.nominatedNodeName = nominatedNodeName;
    }

    public IoK8sApiCoreV1PodStatus phase(String phase) {
        this.phase = phase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The phase of a Pod is a simple, high-level summary of where the Pod is in its lifecycle. The conditions array, the reason and message fields, and the individual container status arrays contain more detail about the pod's status. There are five possible phase values:  Pending: The pod has been accepted by the Kubernetes system, but one or more of the container images has not been created. This includes time before being scheduled as well as time spent downloading images over the network, which could take a while. Running: The pod has been bound to a node, and all of the containers have been created. At least one container is still running, or is in the process of starting or restarting. Succeeded: All containers in the pod have terminated in success, and will not be restarted. Failed: All containers in the pod have terminated, and at least one container has terminated in failure. The container either exited with non-zero status or was terminated by the system. Unknown: For some reason the state of the pod could not be obtained, typically due to an error in communicating with the host of the pod.  More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-phase")
    @JsonProperty(value="phase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public IoK8sApiCoreV1PodStatus podIP(String podIP) {
        this.podIP = podIP;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IP address allocated to the pod. Routable at least within the cluster. Empty if not yet allocated.")
    @JsonProperty(value="podIP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPodIP() {
        return this.podIP;
    }

    public void setPodIP(String podIP) {
        this.podIP = podIP;
    }

    public IoK8sApiCoreV1PodStatus podIPs(List<IoK8sApiCoreV1PodIP> podIPs) {
        this.podIPs = podIPs;
        return this;
    }

    public IoK8sApiCoreV1PodStatus addPodIPsItem(IoK8sApiCoreV1PodIP podIPsItem) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList<IoK8sApiCoreV1PodIP>();
        }
        this.podIPs.add(podIPsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="podIPs holds the IP addresses allocated to the pod. If this field is specified, the 0th entry must match the podIP field. Pods may be allocated at most 1 value for each of IPv4 and IPv6. This list is empty if no IPs have been allocated yet.")
    @JsonProperty(value="podIPs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1PodIP> getPodIPs() {
        return this.podIPs;
    }

    public void setPodIPs(List<IoK8sApiCoreV1PodIP> podIPs) {
        this.podIPs = podIPs;
    }

    public IoK8sApiCoreV1PodStatus qosClass(String qosClass) {
        this.qosClass = qosClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Quality of Service (QOS) classification assigned to the pod based on resource requirements See PodQOSClass type for available QOS classes More info: https://git.k8s.io/community/contributors/design-proposals/node/resource-qos.md")
    @JsonProperty(value="qosClass")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQosClass() {
        return this.qosClass;
    }

    public void setQosClass(String qosClass) {
        this.qosClass = qosClass;
    }

    public IoK8sApiCoreV1PodStatus reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A brief CamelCase message indicating details about why the pod is in this state. e.g. 'Evicted'")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public IoK8sApiCoreV1PodStatus startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.")
    @JsonProperty(value="startTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1PodStatus ioK8sApiCoreV1PodStatus = (IoK8sApiCoreV1PodStatus)o;
        return Objects.equals(this.conditions, ioK8sApiCoreV1PodStatus.conditions) && Objects.equals(this.containerStatuses, ioK8sApiCoreV1PodStatus.containerStatuses) && Objects.equals(this.ephemeralContainerStatuses, ioK8sApiCoreV1PodStatus.ephemeralContainerStatuses) && Objects.equals(this.hostIP, ioK8sApiCoreV1PodStatus.hostIP) && Objects.equals(this.initContainerStatuses, ioK8sApiCoreV1PodStatus.initContainerStatuses) && Objects.equals(this.message, ioK8sApiCoreV1PodStatus.message) && Objects.equals(this.nominatedNodeName, ioK8sApiCoreV1PodStatus.nominatedNodeName) && Objects.equals(this.phase, ioK8sApiCoreV1PodStatus.phase) && Objects.equals(this.podIP, ioK8sApiCoreV1PodStatus.podIP) && Objects.equals(this.podIPs, ioK8sApiCoreV1PodStatus.podIPs) && Objects.equals(this.qosClass, ioK8sApiCoreV1PodStatus.qosClass) && Objects.equals(this.reason, ioK8sApiCoreV1PodStatus.reason) && Objects.equals(this.startTime, ioK8sApiCoreV1PodStatus.startTime);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.containerStatuses, this.ephemeralContainerStatuses, this.hostIP, this.initContainerStatuses, this.message, this.nominatedNodeName, this.phase, this.podIP, this.podIPs, this.qosClass, this.reason, this.startTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1PodStatus {\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    containerStatuses: ").append(this.toIndentedString(this.containerStatuses)).append("\n");
        sb.append("    ephemeralContainerStatuses: ").append(this.toIndentedString(this.ephemeralContainerStatuses)).append("\n");
        sb.append("    hostIP: ").append(this.toIndentedString(this.hostIP)).append("\n");
        sb.append("    initContainerStatuses: ").append(this.toIndentedString(this.initContainerStatuses)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    nominatedNodeName: ").append(this.toIndentedString(this.nominatedNodeName)).append("\n");
        sb.append("    phase: ").append(this.toIndentedString(this.phase)).append("\n");
        sb.append("    podIP: ").append(this.toIndentedString(this.podIP)).append("\n");
        sb.append("    podIPs: ").append(this.toIndentedString(this.podIPs)).append("\n");
        sb.append("    qosClass: ").append(this.toIndentedString(this.qosClass)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

