/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a Quobyte mount that lasts the lifetime of a pod. Quobyte volumes do not support ownership management or SELinux relabeling.")
@JsonPropertyOrder(value={"group", "readOnly", "registry", "tenant", "user", "volume"})
public class IoK8sApiCoreV1QuobyteVolumeSource {
    public static final String JSON_PROPERTY_GROUP = "group";
    private String group;
    public static final String JSON_PROPERTY_READ_ONLY = "readOnly";
    private Boolean readOnly;
    public static final String JSON_PROPERTY_REGISTRY = "registry";
    private String registry;
    public static final String JSON_PROPERTY_TENANT = "tenant";
    private String tenant;
    public static final String JSON_PROPERTY_USER = "user";
    private String user;
    public static final String JSON_PROPERTY_VOLUME = "volume";
    private String volume;

    public IoK8sApiCoreV1QuobyteVolumeSource group(String group) {
        this.group = group;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Group to map volume access to Default is no group")
    @JsonProperty(value="group")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public IoK8sApiCoreV1QuobyteVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ReadOnly here will force the Quobyte volume to be mounted with read-only permissions. Defaults to false.")
    @JsonProperty(value="readOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public IoK8sApiCoreV1QuobyteVolumeSource registry(String registry) {
        this.registry = registry;
        return this;
    }

    @ApiModelProperty(required=true, value="Registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes")
    @JsonProperty(value="registry")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRegistry() {
        return this.registry;
    }

    public void setRegistry(String registry) {
        this.registry = registry;
    }

    public IoK8sApiCoreV1QuobyteVolumeSource tenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Tenant owning the given Quobyte volume in the Backend Used with dynamically provisioned Quobyte volumes, value is set by the plugin")
    @JsonProperty(value="tenant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public IoK8sApiCoreV1QuobyteVolumeSource user(String user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="User to map volume access to Defaults to serivceaccount user")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public IoK8sApiCoreV1QuobyteVolumeSource volume(String volume) {
        this.volume = volume;
        return this;
    }

    @ApiModelProperty(required=true, value="Volume is a string that references an already created Quobyte volume by name.")
    @JsonProperty(value="volume")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getVolume() {
        return this.volume;
    }

    public void setVolume(String volume) {
        this.volume = volume;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1QuobyteVolumeSource ioK8sApiCoreV1QuobyteVolumeSource = (IoK8sApiCoreV1QuobyteVolumeSource)o;
        return Objects.equals(this.group, ioK8sApiCoreV1QuobyteVolumeSource.group) && Objects.equals(this.readOnly, ioK8sApiCoreV1QuobyteVolumeSource.readOnly) && Objects.equals(this.registry, ioK8sApiCoreV1QuobyteVolumeSource.registry) && Objects.equals(this.tenant, ioK8sApiCoreV1QuobyteVolumeSource.tenant) && Objects.equals(this.user, ioK8sApiCoreV1QuobyteVolumeSource.user) && Objects.equals(this.volume, ioK8sApiCoreV1QuobyteVolumeSource.volume);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.readOnly, this.registry, this.tenant, this.user, this.volume);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1QuobyteVolumeSource {\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    registry: ").append(this.toIndentedString(this.registry)).append("\n");
        sb.append("    tenant: ").append(this.toIndentedString(this.tenant)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    volume: ").append(this.toIndentedString(this.volume)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

