/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1SecretReference;

@ApiModel(description="Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD volumes support ownership management and SELinux relabeling.")
@JsonPropertyOrder(value={"fsType", "image", "keyring", "monitors", "pool", "readOnly", "secretRef", "user"})
public class IoK8sApiCoreV1RBDPersistentVolumeSource {
    public static final String JSON_PROPERTY_FS_TYPE = "fsType";
    private String fsType;
    public static final String JSON_PROPERTY_IMAGE = "image";
    private String image;
    public static final String JSON_PROPERTY_KEYRING = "keyring";
    private String keyring;
    public static final String JSON_PROPERTY_MONITORS = "monitors";
    private List<String> monitors = new ArrayList<String>();
    public static final String JSON_PROPERTY_POOL = "pool";
    private String pool;
    public static final String JSON_PROPERTY_READ_ONLY = "readOnly";
    private Boolean readOnly;
    public static final String JSON_PROPERTY_SECRET_REF = "secretRef";
    private IoK8sApiCoreV1SecretReference secretRef;
    public static final String JSON_PROPERTY_USER = "user";
    private String user;

    public IoK8sApiCoreV1RBDPersistentVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd")
    @JsonProperty(value="fsType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public IoK8sApiCoreV1RBDPersistentVolumeSource image(String image) {
        this.image = image;
        return this;
    }

    @ApiModelProperty(required=true, value="The rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    @JsonProperty(value="image")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public IoK8sApiCoreV1RBDPersistentVolumeSource keyring(String keyring) {
        this.keyring = keyring;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    @JsonProperty(value="keyring")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKeyring() {
        return this.keyring;
    }

    public void setKeyring(String keyring) {
        this.keyring = keyring;
    }

    public IoK8sApiCoreV1RBDPersistentVolumeSource monitors(List<String> monitors) {
        this.monitors = monitors;
        return this;
    }

    public IoK8sApiCoreV1RBDPersistentVolumeSource addMonitorsItem(String monitorsItem) {
        this.monitors.add(monitorsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    @JsonProperty(value="monitors")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getMonitors() {
        return this.monitors;
    }

    public void setMonitors(List<String> monitors) {
        this.monitors = monitors;
    }

    public IoK8sApiCoreV1RBDPersistentVolumeSource pool(String pool) {
        this.pool = pool;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    @JsonProperty(value="pool")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPool() {
        return this.pool;
    }

    public void setPool(String pool) {
        this.pool = pool;
    }

    public IoK8sApiCoreV1RBDPersistentVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    @JsonProperty(value="readOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public IoK8sApiCoreV1RBDPersistentVolumeSource secretRef(IoK8sApiCoreV1SecretReference secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="secretRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1SecretReference getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(IoK8sApiCoreV1SecretReference secretRef) {
        this.secretRef = secretRef;
    }

    public IoK8sApiCoreV1RBDPersistentVolumeSource user(String user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1RBDPersistentVolumeSource ioK8sApiCoreV1RBDPersistentVolumeSource = (IoK8sApiCoreV1RBDPersistentVolumeSource)o;
        return Objects.equals(this.fsType, ioK8sApiCoreV1RBDPersistentVolumeSource.fsType) && Objects.equals(this.image, ioK8sApiCoreV1RBDPersistentVolumeSource.image) && Objects.equals(this.keyring, ioK8sApiCoreV1RBDPersistentVolumeSource.keyring) && Objects.equals(this.monitors, ioK8sApiCoreV1RBDPersistentVolumeSource.monitors) && Objects.equals(this.pool, ioK8sApiCoreV1RBDPersistentVolumeSource.pool) && Objects.equals(this.readOnly, ioK8sApiCoreV1RBDPersistentVolumeSource.readOnly) && Objects.equals(this.secretRef, ioK8sApiCoreV1RBDPersistentVolumeSource.secretRef) && Objects.equals(this.user, ioK8sApiCoreV1RBDPersistentVolumeSource.user);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.image, this.keyring, this.monitors, this.pool, this.readOnly, this.secretRef, this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1RBDPersistentVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    keyring: ").append(this.toIndentedString(this.keyring)).append("\n");
        sb.append("    monitors: ").append(this.toIndentedString(this.monitors)).append("\n");
        sb.append("    pool: ").append(this.toIndentedString(this.pool)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    secretRef: ").append(this.toIndentedString(this.secretRef)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

