/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1PodTemplateSpec;

@ApiModel(description="ReplicationControllerSpec is the specification of a replication controller.")
@JsonPropertyOrder(value={"minReadySeconds", "replicas", "selector", "template"})
public class IoK8sApiCoreV1ReplicationControllerSpec {
    public static final String JSON_PROPERTY_MIN_READY_SECONDS = "minReadySeconds";
    private Integer minReadySeconds;
    public static final String JSON_PROPERTY_REPLICAS = "replicas";
    private Integer replicas;
    public static final String JSON_PROPERTY_SELECTOR = "selector";
    private Map<String, String> selector = null;
    public static final String JSON_PROPERTY_TEMPLATE = "template";
    private IoK8sApiCoreV1PodTemplateSpec template;

    public IoK8sApiCoreV1ReplicationControllerSpec minReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)")
    @JsonProperty(value="minReadySeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public void setMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
    }

    public IoK8sApiCoreV1ReplicationControllerSpec replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Replicas is the number of desired replicas. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller")
    @JsonProperty(value="replicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public IoK8sApiCoreV1ReplicationControllerSpec selector(Map<String, String> selector) {
        this.selector = selector;
        return this;
    }

    public IoK8sApiCoreV1ReplicationControllerSpec putSelectorItem(String key, String selectorItem) {
        if (this.selector == null) {
            this.selector = new HashMap<String, String>();
        }
        this.selector.put(key, selectorItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Selector is a label query over pods that should match the Replicas count. If Selector is empty, it is defaulted to the labels present on the Pod template. Label keys and values that must match in order to be controlled by this replication controller, if empty defaulted to labels on Pod template. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors")
    @JsonProperty(value="selector")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getSelector() {
        return this.selector;
    }

    public void setSelector(Map<String, String> selector) {
        this.selector = selector;
    }

    public IoK8sApiCoreV1ReplicationControllerSpec template(IoK8sApiCoreV1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="template")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(IoK8sApiCoreV1PodTemplateSpec template) {
        this.template = template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1ReplicationControllerSpec ioK8sApiCoreV1ReplicationControllerSpec = (IoK8sApiCoreV1ReplicationControllerSpec)o;
        return Objects.equals(this.minReadySeconds, ioK8sApiCoreV1ReplicationControllerSpec.minReadySeconds) && Objects.equals(this.replicas, ioK8sApiCoreV1ReplicationControllerSpec.replicas) && Objects.equals(this.selector, ioK8sApiCoreV1ReplicationControllerSpec.selector) && Objects.equals(this.template, ioK8sApiCoreV1ReplicationControllerSpec.template);
    }

    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.replicas, this.selector, this.template);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1ReplicationControllerSpec {\n");
        sb.append("    minReadySeconds: ").append(this.toIndentedString(this.minReadySeconds)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

