/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1ReplicationControllerCondition;

@ApiModel(description="ReplicationControllerStatus represents the current status of a replication controller.")
@JsonPropertyOrder(value={"availableReplicas", "conditions", "fullyLabeledReplicas", "observedGeneration", "readyReplicas", "replicas"})
public class IoK8sApiCoreV1ReplicationControllerStatus {
    public static final String JSON_PROPERTY_AVAILABLE_REPLICAS = "availableReplicas";
    private Integer availableReplicas;
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private List<IoK8sApiCoreV1ReplicationControllerCondition> conditions = null;
    public static final String JSON_PROPERTY_FULLY_LABELED_REPLICAS = "fullyLabeledReplicas";
    private Integer fullyLabeledReplicas;
    public static final String JSON_PROPERTY_OBSERVED_GENERATION = "observedGeneration";
    private Long observedGeneration;
    public static final String JSON_PROPERTY_READY_REPLICAS = "readyReplicas";
    private Integer readyReplicas;
    public static final String JSON_PROPERTY_REPLICAS = "replicas";
    private Integer replicas;

    public IoK8sApiCoreV1ReplicationControllerStatus availableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of available replicas (ready for at least minReadySeconds) for this replication controller.")
    @JsonProperty(value="availableReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    public void setAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
    }

    public IoK8sApiCoreV1ReplicationControllerStatus conditions(List<IoK8sApiCoreV1ReplicationControllerCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public IoK8sApiCoreV1ReplicationControllerStatus addConditionsItem(IoK8sApiCoreV1ReplicationControllerCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<IoK8sApiCoreV1ReplicationControllerCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents the latest available observations of a replication controller's current state.")
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1ReplicationControllerCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<IoK8sApiCoreV1ReplicationControllerCondition> conditions) {
        this.conditions = conditions;
    }

    public IoK8sApiCoreV1ReplicationControllerStatus fullyLabeledReplicas(Integer fullyLabeledReplicas) {
        this.fullyLabeledReplicas = fullyLabeledReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of pods that have labels matching the labels of the pod template of the replication controller.")
    @JsonProperty(value="fullyLabeledReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFullyLabeledReplicas() {
        return this.fullyLabeledReplicas;
    }

    public void setFullyLabeledReplicas(Integer fullyLabeledReplicas) {
        this.fullyLabeledReplicas = fullyLabeledReplicas;
    }

    public IoK8sApiCoreV1ReplicationControllerStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ObservedGeneration reflects the generation of the most recently observed replication controller.")
    @JsonProperty(value="observedGeneration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public IoK8sApiCoreV1ReplicationControllerStatus readyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of ready replicas for this replication controller.")
    @JsonProperty(value="readyReplicas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public void setReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
    }

    public IoK8sApiCoreV1ReplicationControllerStatus replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @ApiModelProperty(required=true, value="Replicas is the most recently oberved number of replicas. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller")
    @JsonProperty(value="replicas")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1ReplicationControllerStatus ioK8sApiCoreV1ReplicationControllerStatus = (IoK8sApiCoreV1ReplicationControllerStatus)o;
        return Objects.equals(this.availableReplicas, ioK8sApiCoreV1ReplicationControllerStatus.availableReplicas) && Objects.equals(this.conditions, ioK8sApiCoreV1ReplicationControllerStatus.conditions) && Objects.equals(this.fullyLabeledReplicas, ioK8sApiCoreV1ReplicationControllerStatus.fullyLabeledReplicas) && Objects.equals(this.observedGeneration, ioK8sApiCoreV1ReplicationControllerStatus.observedGeneration) && Objects.equals(this.readyReplicas, ioK8sApiCoreV1ReplicationControllerStatus.readyReplicas) && Objects.equals(this.replicas, ioK8sApiCoreV1ReplicationControllerStatus.replicas);
    }

    public int hashCode() {
        return Objects.hash(this.availableReplicas, this.conditions, this.fullyLabeledReplicas, this.observedGeneration, this.readyReplicas, this.replicas);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1ReplicationControllerStatus {\n");
        sb.append("    availableReplicas: ").append(this.toIndentedString(this.availableReplicas)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    fullyLabeledReplicas: ").append(this.toIndentedString(this.fullyLabeledReplicas)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("    readyReplicas: ").append(this.toIndentedString(this.readyReplicas)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

