/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ResourceFieldSelector represents container resources (cpu, memory) and their output format")
@JsonPropertyOrder(value={"containerName", "divisor", "resource"})
public class IoK8sApiCoreV1ResourceFieldSelector {
    public static final String JSON_PROPERTY_CONTAINER_NAME = "containerName";
    private String containerName;
    public static final String JSON_PROPERTY_DIVISOR = "divisor";
    private String divisor;
    public static final String JSON_PROPERTY_RESOURCE = "resource";
    private String resource;

    public IoK8sApiCoreV1ResourceFieldSelector containerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container name: required for volumes, optional for env vars")
    @JsonProperty(value="containerName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public IoK8sApiCoreV1ResourceFieldSelector divisor(String divisor) {
        this.divisor = divisor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Quantity is a fixed-point representation of a number. It provides convenient marshaling/unmarshaling in JSON and YAML, in addition to String() and AsInt64() accessors.  The serialization format is:  <quantity>        ::= <signedNumber><suffix>   (Note that <suffix> may be empty, from the \"\" case in <decimalSI>.) <digit>           ::= 0 | 1 | ... | 9 <digits>          ::= <digit> | <digit><digits> <number>          ::= <digits> | <digits>.<digits> | <digits>. | .<digits> <sign>            ::= \"+\" | \"-\" <signedNumber>    ::= <number> | <sign><number> <suffix>          ::= <binarySI> | <decimalExponent> | <decimalSI> <binarySI>        ::= Ki | Mi | Gi | Ti | Pi | Ei   (International System of units; See: http://physics.nist.gov/cuu/Units/binary.html) <decimalSI>       ::= m | \"\" | k | M | G | T | P | E   (Note that 1024 = 1Ki but 1000 = 1k; I didn't choose the capitalization.) <decimalExponent> ::= \"e\" <signedNumber> | \"E\" <signedNumber>  No matter which of the three exponent forms is used, no quantity may represent a number greater than 2^63-1 in magnitude, nor may it have more than 3 decimal places. Numbers larger or more precise will be capped or rounded up. (E.g.: 0.1m will rounded up to 1m.) This may be extended in the future if we require larger or smaller quantities.  When a Quantity is parsed from a string, it will remember the type of suffix it had, and will use the same type again when it is serialized.  Before serializing, Quantity will be put in \"canonical form\". This means that Exponent/suffix will be adjusted up or down (with a corresponding increase or decrease in Mantissa) such that:   a. No precision is lost   b. No fractional digits will be emitted   c. The exponent (or suffix) is as large as possible. The sign will be omitted unless the number is negative.  Examples:   1.5 will be serialized as \"1500m\"   1.5Gi will be serialized as \"1536Mi\"  Note that the quantity will NEVER be internally represented by a floating point number. That is the whole point of this exercise.  Non-canonical values will still parse as long as they are well formed, but will be re-emitted in their canonical form. (So always use canonical form, or don't diff.)  This format is intended to make it difficult to use these numbers without writing some sort of special handling code in the hopes that that will cause implementors to also use a fixed point implementation.")
    @JsonProperty(value="divisor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDivisor() {
        return this.divisor;
    }

    public void setDivisor(String divisor) {
        this.divisor = divisor;
    }

    public IoK8sApiCoreV1ResourceFieldSelector resource(String resource) {
        this.resource = resource;
        return this;
    }

    @ApiModelProperty(required=true, value="Required: resource to select")
    @JsonProperty(value="resource")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1ResourceFieldSelector ioK8sApiCoreV1ResourceFieldSelector = (IoK8sApiCoreV1ResourceFieldSelector)o;
        return Objects.equals(this.containerName, ioK8sApiCoreV1ResourceFieldSelector.containerName) && Objects.equals(this.divisor, ioK8sApiCoreV1ResourceFieldSelector.divisor) && Objects.equals(this.resource, ioK8sApiCoreV1ResourceFieldSelector.resource);
    }

    public int hashCode() {
        return Objects.hash(this.containerName, this.divisor, this.resource);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1ResourceFieldSelector {\n");
        sb.append("    containerName: ").append(this.toIndentedString(this.containerName)).append("\n");
        sb.append("    divisor: ").append(this.toIndentedString(this.divisor)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

