/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1SecretReference;

@ApiModel(description="ScaleIOPersistentVolumeSource represents a persistent ScaleIO volume")
@JsonPropertyOrder(value={"fsType", "gateway", "protectionDomain", "readOnly", "secretRef", "sslEnabled", "storageMode", "storagePool", "system", "volumeName"})
public class IoK8sApiCoreV1ScaleIOPersistentVolumeSource {
    public static final String JSON_PROPERTY_FS_TYPE = "fsType";
    private String fsType;
    public static final String JSON_PROPERTY_GATEWAY = "gateway";
    private String gateway;
    public static final String JSON_PROPERTY_PROTECTION_DOMAIN = "protectionDomain";
    private String protectionDomain;
    public static final String JSON_PROPERTY_READ_ONLY = "readOnly";
    private Boolean readOnly;
    public static final String JSON_PROPERTY_SECRET_REF = "secretRef";
    private IoK8sApiCoreV1SecretReference secretRef;
    public static final String JSON_PROPERTY_SSL_ENABLED = "sslEnabled";
    private Boolean sslEnabled;
    public static final String JSON_PROPERTY_STORAGE_MODE = "storageMode";
    private String storageMode;
    public static final String JSON_PROPERTY_STORAGE_POOL = "storagePool";
    private String storagePool;
    public static final String JSON_PROPERTY_SYSTEM = "system";
    private String system;
    public static final String JSON_PROPERTY_VOLUME_NAME = "volumeName";
    private String volumeName;

    public IoK8sApiCoreV1ScaleIOPersistentVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Default is \"xfs\"")
    @JsonProperty(value="fsType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public IoK8sApiCoreV1ScaleIOPersistentVolumeSource gateway(String gateway) {
        this.gateway = gateway;
        return this;
    }

    @ApiModelProperty(required=true, value="The host address of the ScaleIO API Gateway.")
    @JsonProperty(value="gateway")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public IoK8sApiCoreV1ScaleIOPersistentVolumeSource protectionDomain(String protectionDomain) {
        this.protectionDomain = protectionDomain;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the ScaleIO Protection Domain for the configured storage.")
    @JsonProperty(value="protectionDomain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProtectionDomain() {
        return this.protectionDomain;
    }

    public void setProtectionDomain(String protectionDomain) {
        this.protectionDomain = protectionDomain;
    }

    public IoK8sApiCoreV1ScaleIOPersistentVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    @JsonProperty(value="readOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public IoK8sApiCoreV1ScaleIOPersistentVolumeSource secretRef(IoK8sApiCoreV1SecretReference secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="secretRef")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IoK8sApiCoreV1SecretReference getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(IoK8sApiCoreV1SecretReference secretRef) {
        this.secretRef = secretRef;
    }

    public IoK8sApiCoreV1ScaleIOPersistentVolumeSource sslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Flag to enable/disable SSL communication with Gateway, default false")
    @JsonProperty(value="sslEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public IoK8sApiCoreV1ScaleIOPersistentVolumeSource storageMode(String storageMode) {
        this.storageMode = storageMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.")
    @JsonProperty(value="storageMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStorageMode() {
        return this.storageMode;
    }

    public void setStorageMode(String storageMode) {
        this.storageMode = storageMode;
    }

    public IoK8sApiCoreV1ScaleIOPersistentVolumeSource storagePool(String storagePool) {
        this.storagePool = storagePool;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ScaleIO Storage Pool associated with the protection domain.")
    @JsonProperty(value="storagePool")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStoragePool() {
        return this.storagePool;
    }

    public void setStoragePool(String storagePool) {
        this.storagePool = storagePool;
    }

    public IoK8sApiCoreV1ScaleIOPersistentVolumeSource system(String system) {
        this.system = system;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the storage system as configured in ScaleIO.")
    @JsonProperty(value="system")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSystem() {
        return this.system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public IoK8sApiCoreV1ScaleIOPersistentVolumeSource volumeName(String volumeName) {
        this.volumeName = volumeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of a volume already created in the ScaleIO system that is associated with this volume source.")
    @JsonProperty(value="volumeName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1ScaleIOPersistentVolumeSource ioK8sApiCoreV1ScaleIOPersistentVolumeSource = (IoK8sApiCoreV1ScaleIOPersistentVolumeSource)o;
        return Objects.equals(this.fsType, ioK8sApiCoreV1ScaleIOPersistentVolumeSource.fsType) && Objects.equals(this.gateway, ioK8sApiCoreV1ScaleIOPersistentVolumeSource.gateway) && Objects.equals(this.protectionDomain, ioK8sApiCoreV1ScaleIOPersistentVolumeSource.protectionDomain) && Objects.equals(this.readOnly, ioK8sApiCoreV1ScaleIOPersistentVolumeSource.readOnly) && Objects.equals(this.secretRef, ioK8sApiCoreV1ScaleIOPersistentVolumeSource.secretRef) && Objects.equals(this.sslEnabled, ioK8sApiCoreV1ScaleIOPersistentVolumeSource.sslEnabled) && Objects.equals(this.storageMode, ioK8sApiCoreV1ScaleIOPersistentVolumeSource.storageMode) && Objects.equals(this.storagePool, ioK8sApiCoreV1ScaleIOPersistentVolumeSource.storagePool) && Objects.equals(this.system, ioK8sApiCoreV1ScaleIOPersistentVolumeSource.system) && Objects.equals(this.volumeName, ioK8sApiCoreV1ScaleIOPersistentVolumeSource.volumeName);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.gateway, this.protectionDomain, this.readOnly, this.secretRef, this.sslEnabled, this.storageMode, this.storagePool, this.system, this.volumeName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1ScaleIOPersistentVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    gateway: ").append(this.toIndentedString(this.gateway)).append("\n");
        sb.append("    protectionDomain: ").append(this.toIndentedString(this.protectionDomain)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    secretRef: ").append(this.toIndentedString(this.secretRef)).append("\n");
        sb.append("    sslEnabled: ").append(this.toIndentedString(this.sslEnabled)).append("\n");
        sb.append("    storageMode: ").append(this.toIndentedString(this.storageMode)).append("\n");
        sb.append("    storagePool: ").append(this.toIndentedString(this.storagePool)).append("\n");
        sb.append("    system: ").append(this.toIndentedString(this.system)).append("\n");
        sb.append("    volumeName: ").append(this.toIndentedString(this.volumeName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

