/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A scoped-resource selector requirement is a selector that contains values, a scope name, and an operator that relates the scope name and values.")
@JsonPropertyOrder(value={"operator", "scopeName", "values"})
public class IoK8sApiCoreV1ScopedResourceSelectorRequirement {
    public static final String JSON_PROPERTY_OPERATOR = "operator";
    private String operator;
    public static final String JSON_PROPERTY_SCOPE_NAME = "scopeName";
    private String scopeName;
    public static final String JSON_PROPERTY_VALUES = "values";
    private List<String> values = null;

    public IoK8sApiCoreV1ScopedResourceSelectorRequirement operator(String operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(required=true, value="Represents a scope's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist.")
    @JsonProperty(value="operator")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public IoK8sApiCoreV1ScopedResourceSelectorRequirement scopeName(String scopeName) {
        this.scopeName = scopeName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the scope that the selector applies to.")
    @JsonProperty(value="scopeName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getScopeName() {
        return this.scopeName;
    }

    public void setScopeName(String scopeName) {
        this.scopeName = scopeName;
    }

    public IoK8sApiCoreV1ScopedResourceSelectorRequirement values(List<String> values) {
        this.values = values;
        return this;
    }

    public IoK8sApiCoreV1ScopedResourceSelectorRequirement addValuesItem(String valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.")
    @JsonProperty(value="values")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1ScopedResourceSelectorRequirement ioK8sApiCoreV1ScopedResourceSelectorRequirement = (IoK8sApiCoreV1ScopedResourceSelectorRequirement)o;
        return Objects.equals(this.operator, ioK8sApiCoreV1ScopedResourceSelectorRequirement.operator) && Objects.equals(this.scopeName, ioK8sApiCoreV1ScopedResourceSelectorRequirement.scopeName) && Objects.equals(this.values, ioK8sApiCoreV1ScopedResourceSelectorRequirement.values);
    }

    public int hashCode() {
        return Objects.hash(this.operator, this.scopeName, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1ScopedResourceSelectorRequirement {\n");
        sb.append("    operator: ").append(this.toIndentedString(this.operator)).append("\n");
        sb.append("    scopeName: ").append(this.toIndentedString(this.scopeName)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

