/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApimachineryPkgApisMetaV1ObjectMeta;

@ApiModel(description="Secret holds secret data of a certain type. The total bytes of the values in the Data field must be less than MaxSecretSize bytes.")
@JsonPropertyOrder(value={"apiVersion", "data", "immutable", "kind", "metadata", "stringData", "type"})
public class IoK8sApiCoreV1Secret {
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    private String apiVersion;
    public static final String JSON_PROPERTY_DATA = "data";
    private Map<String, byte[]> data = null;
    public static final String JSON_PROPERTY_IMMUTABLE = "immutable";
    private Boolean immutable;
    public static final String JSON_PROPERTY_KIND = "kind";
    private String kind;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private IoK8sApimachineryPkgApisMetaV1ObjectMeta metadata;
    public static final String JSON_PROPERTY_STRING_DATA = "stringData";
    private Map<String, String> stringData = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public IoK8sApiCoreV1Secret apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public IoK8sApiCoreV1Secret data(Map<String, byte[]> data) {
        this.data = data;
        return this;
    }

    public IoK8sApiCoreV1Secret putDataItem(String key, byte[] dataItem) {
        if (this.data == null) {
            this.data = new HashMap<String, byte[]>();
        }
        this.data.put(key, dataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Data contains the secret data. Each key must consist of alphanumeric characters, '-', '_' or '.'. The serialized form of the secret data is a base64 encoded string, representing the arbitrary (possibly non-string) data value here. Described in https://tools.ietf.org/html/rfc4648#section-4")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, byte[]> getData() {
        return this.data;
    }

    public void setData(Map<String, byte[]> data) {
        this.data = data;
    }

    public IoK8sApiCoreV1Secret immutable(Boolean immutable) {
        this.immutable = immutable;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Immutable, if set to true, ensures that data stored in the Secret cannot be updated (only object metadata can be modified). If not set to true, the field can be modified at any time. Defaulted to nil. This is an alpha field enabled by ImmutableEphemeralVolumes feature gate.")
    @JsonProperty(value="immutable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getImmutable() {
        return this.immutable;
    }

    public void setImmutable(Boolean immutable) {
        this.immutable = immutable;
    }

    public IoK8sApiCoreV1Secret kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public IoK8sApiCoreV1Secret metadata(IoK8sApimachineryPkgApisMetaV1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApimachineryPkgApisMetaV1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(IoK8sApimachineryPkgApisMetaV1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public IoK8sApiCoreV1Secret stringData(Map<String, String> stringData) {
        this.stringData = stringData;
        return this;
    }

    public IoK8sApiCoreV1Secret putStringDataItem(String key, String stringDataItem) {
        if (this.stringData == null) {
            this.stringData = new HashMap<String, String>();
        }
        this.stringData.put(key, stringDataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="stringData allows specifying non-binary secret data in string form. It is provided as a write-only convenience method. All keys and values are merged into the data field on write, overwriting any existing values. It is never output when reading from the API.")
    @JsonProperty(value="stringData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getStringData() {
        return this.stringData;
    }

    public void setStringData(Map<String, String> stringData) {
        this.stringData = stringData;
    }

    public IoK8sApiCoreV1Secret type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Used to facilitate programmatic handling of secret data.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1Secret ioK8sApiCoreV1Secret = (IoK8sApiCoreV1Secret)o;
        return Objects.equals(this.apiVersion, ioK8sApiCoreV1Secret.apiVersion) && Objects.equals(this.data, ioK8sApiCoreV1Secret.data) && Objects.equals(this.immutable, ioK8sApiCoreV1Secret.immutable) && Objects.equals(this.kind, ioK8sApiCoreV1Secret.kind) && Objects.equals(this.metadata, ioK8sApiCoreV1Secret.metadata) && Objects.equals(this.stringData, ioK8sApiCoreV1Secret.stringData) && Objects.equals(this.type, ioK8sApiCoreV1Secret.type);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.data, this.immutable, this.kind, this.metadata, this.stringData, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1Secret {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    immutable: ").append(this.toIndentedString(this.immutable)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    stringData: ").append(this.toIndentedString(this.stringData)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

