/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1KeyToPath;

@ApiModel(description="Adapts a secret into a projected volume.  The contents of the target Secret's Data field will be presented in a projected volume as files using the keys in the Data field as the file names. Note that this is identical to a secret volume source without the default mode.")
@JsonPropertyOrder(value={"items", "name", "optional"})
public class IoK8sApiCoreV1SecretProjection {
    public static final String JSON_PROPERTY_ITEMS = "items";
    private List<IoK8sApiCoreV1KeyToPath> items = null;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OPTIONAL = "optional";
    private Boolean optional;

    public IoK8sApiCoreV1SecretProjection items(List<IoK8sApiCoreV1KeyToPath> items) {
        this.items = items;
        return this;
    }

    public IoK8sApiCoreV1SecretProjection addItemsItem(IoK8sApiCoreV1KeyToPath itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<IoK8sApiCoreV1KeyToPath>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.")
    @JsonProperty(value="items")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1KeyToPath> getItems() {
        return this.items;
    }

    public void setItems(List<IoK8sApiCoreV1KeyToPath> items) {
        this.items = items;
    }

    public IoK8sApiCoreV1SecretProjection name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IoK8sApiCoreV1SecretProjection optional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specify whether the Secret or its key must be defined")
    @JsonProperty(value="optional")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getOptional() {
        return this.optional;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1SecretProjection ioK8sApiCoreV1SecretProjection = (IoK8sApiCoreV1SecretProjection)o;
        return Objects.equals(this.items, ioK8sApiCoreV1SecretProjection.items) && Objects.equals(this.name, ioK8sApiCoreV1SecretProjection.name) && Objects.equals(this.optional, ioK8sApiCoreV1SecretProjection.optional);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.name, this.optional);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1SecretProjection {\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    optional: ").append(this.toIndentedString(this.optional)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

