/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1Capabilities;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1SELinuxOptions;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1WindowsSecurityContextOptions;

@ApiModel(description="SecurityContext holds security configuration that will be applied to a container. Some fields are present in both SecurityContext and PodSecurityContext.  When both are set, the values in SecurityContext take precedence.")
@JsonPropertyOrder(value={"allowPrivilegeEscalation", "capabilities", "privileged", "procMount", "readOnlyRootFilesystem", "runAsGroup", "runAsNonRoot", "runAsUser", "seLinuxOptions", "windowsOptions"})
public class IoK8sApiCoreV1SecurityContext {
    public static final String JSON_PROPERTY_ALLOW_PRIVILEGE_ESCALATION = "allowPrivilegeEscalation";
    private Boolean allowPrivilegeEscalation;
    public static final String JSON_PROPERTY_CAPABILITIES = "capabilities";
    private IoK8sApiCoreV1Capabilities capabilities;
    public static final String JSON_PROPERTY_PRIVILEGED = "privileged";
    private Boolean privileged;
    public static final String JSON_PROPERTY_PROC_MOUNT = "procMount";
    private String procMount;
    public static final String JSON_PROPERTY_READ_ONLY_ROOT_FILESYSTEM = "readOnlyRootFilesystem";
    private Boolean readOnlyRootFilesystem;
    public static final String JSON_PROPERTY_RUN_AS_GROUP = "runAsGroup";
    private Long runAsGroup;
    public static final String JSON_PROPERTY_RUN_AS_NON_ROOT = "runAsNonRoot";
    private Boolean runAsNonRoot;
    public static final String JSON_PROPERTY_RUN_AS_USER = "runAsUser";
    private Long runAsUser;
    public static final String JSON_PROPERTY_SE_LINUX_OPTIONS = "seLinuxOptions";
    private IoK8sApiCoreV1SELinuxOptions seLinuxOptions;
    public static final String JSON_PROPERTY_WINDOWS_OPTIONS = "windowsOptions";
    private IoK8sApiCoreV1WindowsSecurityContextOptions windowsOptions;

    public IoK8sApiCoreV1SecurityContext allowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN")
    @JsonProperty(value="allowPrivilegeEscalation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    public void setAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
    }

    public IoK8sApiCoreV1SecurityContext capabilities(IoK8sApiCoreV1Capabilities capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1Capabilities getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(IoK8sApiCoreV1Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    public IoK8sApiCoreV1SecurityContext privileged(Boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.")
    @JsonProperty(value="privileged")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPrivileged() {
        return this.privileged;
    }

    public void setPrivileged(Boolean privileged) {
        this.privileged = privileged;
    }

    public IoK8sApiCoreV1SecurityContext procMount(String procMount) {
        this.procMount = procMount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="procMount denotes the type of proc mount to use for the containers. The default is DefaultProcMount which uses the container runtime defaults for readonly paths and masked paths. This requires the ProcMountType feature flag to be enabled.")
    @JsonProperty(value="procMount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProcMount() {
        return this.procMount;
    }

    public void setProcMount(String procMount) {
        this.procMount = procMount;
    }

    public IoK8sApiCoreV1SecurityContext readOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this container has a read-only root filesystem. Default is false.")
    @JsonProperty(value="readOnlyRootFilesystem")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    public void setReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
    }

    public IoK8sApiCoreV1SecurityContext runAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.")
    @JsonProperty(value="runAsGroup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    public void setRunAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
    }

    public IoK8sApiCoreV1SecurityContext runAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.")
    @JsonProperty(value="runAsNonRoot")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public void setRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
    }

    public IoK8sApiCoreV1SecurityContext runAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.")
    @JsonProperty(value="runAsUser")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public void setRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
    }

    public IoK8sApiCoreV1SecurityContext seLinuxOptions(IoK8sApiCoreV1SELinuxOptions seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="seLinuxOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions;
    }

    public void setSeLinuxOptions(IoK8sApiCoreV1SELinuxOptions seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
    }

    public IoK8sApiCoreV1SecurityContext windowsOptions(IoK8sApiCoreV1WindowsSecurityContextOptions windowsOptions) {
        this.windowsOptions = windowsOptions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="windowsOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1WindowsSecurityContextOptions getWindowsOptions() {
        return this.windowsOptions;
    }

    public void setWindowsOptions(IoK8sApiCoreV1WindowsSecurityContextOptions windowsOptions) {
        this.windowsOptions = windowsOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1SecurityContext ioK8sApiCoreV1SecurityContext = (IoK8sApiCoreV1SecurityContext)o;
        return Objects.equals(this.allowPrivilegeEscalation, ioK8sApiCoreV1SecurityContext.allowPrivilegeEscalation) && Objects.equals(this.capabilities, ioK8sApiCoreV1SecurityContext.capabilities) && Objects.equals(this.privileged, ioK8sApiCoreV1SecurityContext.privileged) && Objects.equals(this.procMount, ioK8sApiCoreV1SecurityContext.procMount) && Objects.equals(this.readOnlyRootFilesystem, ioK8sApiCoreV1SecurityContext.readOnlyRootFilesystem) && Objects.equals(this.runAsGroup, ioK8sApiCoreV1SecurityContext.runAsGroup) && Objects.equals(this.runAsNonRoot, ioK8sApiCoreV1SecurityContext.runAsNonRoot) && Objects.equals(this.runAsUser, ioK8sApiCoreV1SecurityContext.runAsUser) && Objects.equals(this.seLinuxOptions, ioK8sApiCoreV1SecurityContext.seLinuxOptions) && Objects.equals(this.windowsOptions, ioK8sApiCoreV1SecurityContext.windowsOptions);
    }

    public int hashCode() {
        return Objects.hash(this.allowPrivilegeEscalation, this.capabilities, this.privileged, this.procMount, this.readOnlyRootFilesystem, this.runAsGroup, this.runAsNonRoot, this.runAsUser, this.seLinuxOptions, this.windowsOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1SecurityContext {\n");
        sb.append("    allowPrivilegeEscalation: ").append(this.toIndentedString(this.allowPrivilegeEscalation)).append("\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    privileged: ").append(this.toIndentedString(this.privileged)).append("\n");
        sb.append("    procMount: ").append(this.toIndentedString(this.procMount)).append("\n");
        sb.append("    readOnlyRootFilesystem: ").append(this.toIndentedString(this.readOnlyRootFilesystem)).append("\n");
        sb.append("    runAsGroup: ").append(this.toIndentedString(this.runAsGroup)).append("\n");
        sb.append("    runAsNonRoot: ").append(this.toIndentedString(this.runAsNonRoot)).append("\n");
        sb.append("    runAsUser: ").append(this.toIndentedString(this.runAsUser)).append("\n");
        sb.append("    seLinuxOptions: ").append(this.toIndentedString(this.seLinuxOptions)).append("\n");
        sb.append("    windowsOptions: ").append(this.toIndentedString(this.windowsOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

