/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1LocalObjectReference;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1ObjectReference;
import net.stickycode.kuuty.model.v18.IoK8sApimachineryPkgApisMetaV1ObjectMeta;

@ApiModel(description="ServiceAccount binds together: * a name, understood by users, and perhaps by peripheral systems, for an identity * a principal that can be authenticated and authorized * a set of secrets")
@JsonPropertyOrder(value={"apiVersion", "automountServiceAccountToken", "imagePullSecrets", "kind", "metadata", "secrets"})
public class IoK8sApiCoreV1ServiceAccount {
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    private String apiVersion;
    public static final String JSON_PROPERTY_AUTOMOUNT_SERVICE_ACCOUNT_TOKEN = "automountServiceAccountToken";
    private Boolean automountServiceAccountToken;
    public static final String JSON_PROPERTY_IMAGE_PULL_SECRETS = "imagePullSecrets";
    private List<IoK8sApiCoreV1LocalObjectReference> imagePullSecrets = null;
    public static final String JSON_PROPERTY_KIND = "kind";
    private String kind;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private IoK8sApimachineryPkgApisMetaV1ObjectMeta metadata;
    public static final String JSON_PROPERTY_SECRETS = "secrets";
    private List<IoK8sApiCoreV1ObjectReference> secrets = null;

    public IoK8sApiCoreV1ServiceAccount apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public IoK8sApiCoreV1ServiceAccount automountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AutomountServiceAccountToken indicates whether pods running as this service account should have an API token automatically mounted. Can be overridden at the pod level.")
    @JsonProperty(value="automountServiceAccountToken")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    public void setAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
    }

    public IoK8sApiCoreV1ServiceAccount imagePullSecrets(List<IoK8sApiCoreV1LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
        return this;
    }

    public IoK8sApiCoreV1ServiceAccount addImagePullSecretsItem(IoK8sApiCoreV1LocalObjectReference imagePullSecretsItem) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<IoK8sApiCoreV1LocalObjectReference>();
        }
        this.imagePullSecrets.add(imagePullSecretsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ImagePullSecrets is a list of references to secrets in the same namespace to use for pulling any images in pods that reference this ServiceAccount. ImagePullSecrets are distinct from Secrets because Secrets can be mounted in the pod, but ImagePullSecrets are only accessed by the kubelet. More info: https://kubernetes.io/docs/concepts/containers/images/#specifying-imagepullsecrets-on-a-pod")
    @JsonProperty(value="imagePullSecrets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1LocalObjectReference> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    public void setImagePullSecrets(List<IoK8sApiCoreV1LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
    }

    public IoK8sApiCoreV1ServiceAccount kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public IoK8sApiCoreV1ServiceAccount metadata(IoK8sApimachineryPkgApisMetaV1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApimachineryPkgApisMetaV1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(IoK8sApimachineryPkgApisMetaV1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public IoK8sApiCoreV1ServiceAccount secrets(List<IoK8sApiCoreV1ObjectReference> secrets) {
        this.secrets = secrets;
        return this;
    }

    public IoK8sApiCoreV1ServiceAccount addSecretsItem(IoK8sApiCoreV1ObjectReference secretsItem) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<IoK8sApiCoreV1ObjectReference>();
        }
        this.secrets.add(secretsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Secrets is the list of secrets allowed to be used by pods running using this ServiceAccount. More info: https://kubernetes.io/docs/concepts/configuration/secret")
    @JsonProperty(value="secrets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiCoreV1ObjectReference> getSecrets() {
        return this.secrets;
    }

    public void setSecrets(List<IoK8sApiCoreV1ObjectReference> secrets) {
        this.secrets = secrets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1ServiceAccount ioK8sApiCoreV1ServiceAccount = (IoK8sApiCoreV1ServiceAccount)o;
        return Objects.equals(this.apiVersion, ioK8sApiCoreV1ServiceAccount.apiVersion) && Objects.equals(this.automountServiceAccountToken, ioK8sApiCoreV1ServiceAccount.automountServiceAccountToken) && Objects.equals(this.imagePullSecrets, ioK8sApiCoreV1ServiceAccount.imagePullSecrets) && Objects.equals(this.kind, ioK8sApiCoreV1ServiceAccount.kind) && Objects.equals(this.metadata, ioK8sApiCoreV1ServiceAccount.metadata) && Objects.equals(this.secrets, ioK8sApiCoreV1ServiceAccount.secrets);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.automountServiceAccountToken, this.imagePullSecrets, this.kind, this.metadata, this.secrets);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1ServiceAccount {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    automountServiceAccountToken: ").append(this.toIndentedString(this.automountServiceAccountToken)).append("\n");
        sb.append("    imagePullSecrets: ").append(this.toIndentedString(this.imagePullSecrets)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    secrets: ").append(this.toIndentedString(this.secrets)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

