/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiCoreV1LocalObjectReference;

@ApiModel(description="Represents a StorageOS persistent volume resource.")
@JsonPropertyOrder(value={"fsType", "readOnly", "secretRef", "volumeName", "volumeNamespace"})
public class IoK8sApiCoreV1StorageOSVolumeSource {
    public static final String JSON_PROPERTY_FS_TYPE = "fsType";
    private String fsType;
    public static final String JSON_PROPERTY_READ_ONLY = "readOnly";
    private Boolean readOnly;
    public static final String JSON_PROPERTY_SECRET_REF = "secretRef";
    private IoK8sApiCoreV1LocalObjectReference secretRef;
    public static final String JSON_PROPERTY_VOLUME_NAME = "volumeName";
    private String volumeName;
    public static final String JSON_PROPERTY_VOLUME_NAMESPACE = "volumeNamespace";
    private String volumeNamespace;

    public IoK8sApiCoreV1StorageOSVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.")
    @JsonProperty(value="fsType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public IoK8sApiCoreV1StorageOSVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    @JsonProperty(value="readOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public IoK8sApiCoreV1StorageOSVolumeSource secretRef(IoK8sApiCoreV1LocalObjectReference secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="secretRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiCoreV1LocalObjectReference getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(IoK8sApiCoreV1LocalObjectReference secretRef) {
        this.secretRef = secretRef;
    }

    public IoK8sApiCoreV1StorageOSVolumeSource volumeName(String volumeName) {
        this.volumeName = volumeName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="VolumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace.")
    @JsonProperty(value="volumeName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public IoK8sApiCoreV1StorageOSVolumeSource volumeNamespace(String volumeNamespace) {
        this.volumeNamespace = volumeNamespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="VolumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to \"default\" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.")
    @JsonProperty(value="volumeNamespace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVolumeNamespace() {
        return this.volumeNamespace;
    }

    public void setVolumeNamespace(String volumeNamespace) {
        this.volumeNamespace = volumeNamespace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1StorageOSVolumeSource ioK8sApiCoreV1StorageOSVolumeSource = (IoK8sApiCoreV1StorageOSVolumeSource)o;
        return Objects.equals(this.fsType, ioK8sApiCoreV1StorageOSVolumeSource.fsType) && Objects.equals(this.readOnly, ioK8sApiCoreV1StorageOSVolumeSource.readOnly) && Objects.equals(this.secretRef, ioK8sApiCoreV1StorageOSVolumeSource.secretRef) && Objects.equals(this.volumeName, ioK8sApiCoreV1StorageOSVolumeSource.volumeName) && Objects.equals(this.volumeNamespace, ioK8sApiCoreV1StorageOSVolumeSource.volumeNamespace);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.readOnly, this.secretRef, this.volumeName, this.volumeNamespace);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1StorageOSVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    secretRef: ").append(this.toIndentedString(this.secretRef)).append("\n");
        sb.append("    volumeName: ").append(this.toIndentedString(this.volumeName)).append("\n");
        sb.append("    volumeNamespace: ").append(this.toIndentedString(this.volumeNamespace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

