/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The node this Taint is attached to has the \"effect\" on any pod that does not tolerate the Taint.")
@JsonPropertyOrder(value={"effect", "key", "timeAdded", "value"})
public class IoK8sApiCoreV1Taint {
    public static final String JSON_PROPERTY_EFFECT = "effect";
    private String effect;
    public static final String JSON_PROPERTY_KEY = "key";
    private String key;
    public static final String JSON_PROPERTY_TIME_ADDED = "timeAdded";
    private OffsetDateTime timeAdded;
    public static final String JSON_PROPERTY_VALUE = "value";
    private String value;

    public IoK8sApiCoreV1Taint effect(String effect) {
        this.effect = effect;
        return this;
    }

    @ApiModelProperty(required=true, value="Required. The effect of the taint on pods that do not tolerate the taint. Valid effects are NoSchedule, PreferNoSchedule and NoExecute.")
    @JsonProperty(value="effect")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEffect() {
        return this.effect;
    }

    public void setEffect(String effect) {
        this.effect = effect;
    }

    public IoK8sApiCoreV1Taint key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(required=true, value="Required. The taint key to be applied to a node.")
    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public IoK8sApiCoreV1Taint timeAdded(OffsetDateTime timeAdded) {
        this.timeAdded = timeAdded;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time is a wrapper around time.Time which supports correct marshaling to YAML and JSON.  Wrappers are provided for many of the factory methods that the time package offers.")
    @JsonProperty(value="timeAdded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getTimeAdded() {
        return this.timeAdded;
    }

    public void setTimeAdded(OffsetDateTime timeAdded) {
        this.timeAdded = timeAdded;
    }

    public IoK8sApiCoreV1Taint value(String value) {
        this.value = value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The taint value corresponding to the taint key.")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1Taint ioK8sApiCoreV1Taint = (IoK8sApiCoreV1Taint)o;
        return Objects.equals(this.effect, ioK8sApiCoreV1Taint.effect) && Objects.equals(this.key, ioK8sApiCoreV1Taint.key) && Objects.equals(this.timeAdded, ioK8sApiCoreV1Taint.timeAdded) && Objects.equals(this.value, ioK8sApiCoreV1Taint.value);
    }

    public int hashCode() {
        return Objects.hash(this.effect, this.key, this.timeAdded, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1Taint {\n");
        sb.append("    effect: ").append(this.toIndentedString(this.effect)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    timeAdded: ").append(this.toIndentedString(this.timeAdded)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

