/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApimachineryPkgApisMetaV1LabelSelector;

@ApiModel(description="TopologySpreadConstraint specifies how to spread matching pods among the given topology.")
@JsonPropertyOrder(value={"labelSelector", "maxSkew", "topologyKey", "whenUnsatisfiable"})
public class IoK8sApiCoreV1TopologySpreadConstraint {
    public static final String JSON_PROPERTY_LABEL_SELECTOR = "labelSelector";
    private IoK8sApimachineryPkgApisMetaV1LabelSelector labelSelector;
    public static final String JSON_PROPERTY_MAX_SKEW = "maxSkew";
    private Integer maxSkew;
    public static final String JSON_PROPERTY_TOPOLOGY_KEY = "topologyKey";
    private String topologyKey;
    public static final String JSON_PROPERTY_WHEN_UNSATISFIABLE = "whenUnsatisfiable";
    private String whenUnsatisfiable;

    public IoK8sApiCoreV1TopologySpreadConstraint labelSelector(IoK8sApimachineryPkgApisMetaV1LabelSelector labelSelector) {
        this.labelSelector = labelSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="labelSelector")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApimachineryPkgApisMetaV1LabelSelector getLabelSelector() {
        return this.labelSelector;
    }

    public void setLabelSelector(IoK8sApimachineryPkgApisMetaV1LabelSelector labelSelector) {
        this.labelSelector = labelSelector;
    }

    public IoK8sApiCoreV1TopologySpreadConstraint maxSkew(Integer maxSkew) {
        this.maxSkew = maxSkew;
        return this;
    }

    @ApiModelProperty(required=true, value="MaxSkew describes the degree to which pods may be unevenly distributed. It's the maximum permitted difference between the number of matching pods in any two topology domains of a given topology type. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 1/1/0: | zone1 | zone2 | zone3 | |   P   |   P   |       | - if MaxSkew is 1, incoming pod can only be scheduled to zone3 to become 1/1/1; scheduling it onto zone1(zone2) would make the ActualSkew(2-0) on zone1(zone2) violate MaxSkew(1). - if MaxSkew is 2, incoming pod can be scheduled onto any zone. It's a required field. Default value is 1 and 0 is not allowed.")
    @JsonProperty(value="maxSkew")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Integer getMaxSkew() {
        return this.maxSkew;
    }

    public void setMaxSkew(Integer maxSkew) {
        this.maxSkew = maxSkew;
    }

    public IoK8sApiCoreV1TopologySpreadConstraint topologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
        return this;
    }

    @ApiModelProperty(required=true, value="TopologyKey is the key of node labels. Nodes that have a label with this key and identical values are considered to be in the same topology. We consider each <key, value> as a \"bucket\", and try to put balanced number of pods into each bucket. It's a required field.")
    @JsonProperty(value="topologyKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTopologyKey() {
        return this.topologyKey;
    }

    public void setTopologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
    }

    public IoK8sApiCoreV1TopologySpreadConstraint whenUnsatisfiable(String whenUnsatisfiable) {
        this.whenUnsatisfiable = whenUnsatisfiable;
        return this;
    }

    @ApiModelProperty(required=true, value="WhenUnsatisfiable indicates how to deal with a pod if it doesn't satisfy the spread constraint. - DoNotSchedule (default) tells the scheduler not to schedule it - ScheduleAnyway tells the scheduler to still schedule it It's considered as \"Unsatisfiable\" if and only if placing incoming pod on any topology violates \"MaxSkew\". For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 3/1/1: | zone1 | zone2 | zone3 | | P P P |   P   |   P   | If WhenUnsatisfiable is set to DoNotSchedule, incoming pod can only be scheduled to zone2(zone3) to become 3/2/1(3/1/2) as ActualSkew(2-1) on zone2(zone3) satisfies MaxSkew(1). In other words, the cluster can still be imbalanced, but scheduler won't make it *more* imbalanced. It's a required field.")
    @JsonProperty(value="whenUnsatisfiable")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getWhenUnsatisfiable() {
        return this.whenUnsatisfiable;
    }

    public void setWhenUnsatisfiable(String whenUnsatisfiable) {
        this.whenUnsatisfiable = whenUnsatisfiable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1TopologySpreadConstraint ioK8sApiCoreV1TopologySpreadConstraint = (IoK8sApiCoreV1TopologySpreadConstraint)o;
        return Objects.equals(this.labelSelector, ioK8sApiCoreV1TopologySpreadConstraint.labelSelector) && Objects.equals(this.maxSkew, ioK8sApiCoreV1TopologySpreadConstraint.maxSkew) && Objects.equals(this.topologyKey, ioK8sApiCoreV1TopologySpreadConstraint.topologyKey) && Objects.equals(this.whenUnsatisfiable, ioK8sApiCoreV1TopologySpreadConstraint.whenUnsatisfiable);
    }

    public int hashCode() {
        return Objects.hash(this.labelSelector, this.maxSkew, this.topologyKey, this.whenUnsatisfiable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1TopologySpreadConstraint {\n");
        sb.append("    labelSelector: ").append(this.toIndentedString(this.labelSelector)).append("\n");
        sb.append("    maxSkew: ").append(this.toIndentedString(this.maxSkew)).append("\n");
        sb.append("    topologyKey: ").append(this.toIndentedString(this.topologyKey)).append("\n");
        sb.append("    whenUnsatisfiable: ").append(this.toIndentedString(this.whenUnsatisfiable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

