/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="VolumeMount describes a mounting of a Volume within a container.")
@JsonPropertyOrder(value={"mountPath", "mountPropagation", "name", "readOnly", "subPath", "subPathExpr"})
public class IoK8sApiCoreV1VolumeMount {
    public static final String JSON_PROPERTY_MOUNT_PATH = "mountPath";
    private String mountPath;
    public static final String JSON_PROPERTY_MOUNT_PROPAGATION = "mountPropagation";
    private String mountPropagation;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_READ_ONLY = "readOnly";
    private Boolean readOnly;
    public static final String JSON_PROPERTY_SUB_PATH = "subPath";
    private String subPath;
    public static final String JSON_PROPERTY_SUB_PATH_EXPR = "subPathExpr";
    private String subPathExpr;

    public IoK8sApiCoreV1VolumeMount mountPath(String mountPath) {
        this.mountPath = mountPath;
        return this;
    }

    @ApiModelProperty(required=true, value="Path within the container at which the volume should be mounted.  Must not contain ':'.")
    @JsonProperty(value="mountPath")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMountPath() {
        return this.mountPath;
    }

    public void setMountPath(String mountPath) {
        this.mountPath = mountPath;
    }

    public IoK8sApiCoreV1VolumeMount mountPropagation(String mountPropagation) {
        this.mountPropagation = mountPropagation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="mountPropagation determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used. This field is beta in 1.10.")
    @JsonProperty(value="mountPropagation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMountPropagation() {
        return this.mountPropagation;
    }

    public void setMountPropagation(String mountPropagation) {
        this.mountPropagation = mountPropagation;
    }

    public IoK8sApiCoreV1VolumeMount name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="This must match the Name of a Volume.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IoK8sApiCoreV1VolumeMount readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.")
    @JsonProperty(value="readOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public IoK8sApiCoreV1VolumeMount subPath(String subPath) {
        this.subPath = subPath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Path within the volume from which the container's volume should be mounted. Defaults to \"\" (volume's root).")
    @JsonProperty(value="subPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubPath() {
        return this.subPath;
    }

    public void setSubPath(String subPath) {
        this.subPath = subPath;
    }

    public IoK8sApiCoreV1VolumeMount subPathExpr(String subPathExpr) {
        this.subPathExpr = subPathExpr;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to \"\" (volume's root). SubPathExpr and SubPath are mutually exclusive.")
    @JsonProperty(value="subPathExpr")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubPathExpr() {
        return this.subPathExpr;
    }

    public void setSubPathExpr(String subPathExpr) {
        this.subPathExpr = subPathExpr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1VolumeMount ioK8sApiCoreV1VolumeMount = (IoK8sApiCoreV1VolumeMount)o;
        return Objects.equals(this.mountPath, ioK8sApiCoreV1VolumeMount.mountPath) && Objects.equals(this.mountPropagation, ioK8sApiCoreV1VolumeMount.mountPropagation) && Objects.equals(this.name, ioK8sApiCoreV1VolumeMount.name) && Objects.equals(this.readOnly, ioK8sApiCoreV1VolumeMount.readOnly) && Objects.equals(this.subPath, ioK8sApiCoreV1VolumeMount.subPath) && Objects.equals(this.subPathExpr, ioK8sApiCoreV1VolumeMount.subPathExpr);
    }

    public int hashCode() {
        return Objects.hash(this.mountPath, this.mountPropagation, this.name, this.readOnly, this.subPath, this.subPathExpr);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1VolumeMount {\n");
        sb.append("    mountPath: ").append(this.toIndentedString(this.mountPath)).append("\n");
        sb.append("    mountPropagation: ").append(this.toIndentedString(this.mountPropagation)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    subPath: ").append(this.toIndentedString(this.subPath)).append("\n");
        sb.append("    subPathExpr: ").append(this.toIndentedString(this.subPathExpr)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

