/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="WindowsSecurityContextOptions contain Windows-specific options and credentials.")
@JsonPropertyOrder(value={"gmsaCredentialSpec", "gmsaCredentialSpecName", "runAsUserName"})
public class IoK8sApiCoreV1WindowsSecurityContextOptions {
    public static final String JSON_PROPERTY_GMSA_CREDENTIAL_SPEC = "gmsaCredentialSpec";
    private String gmsaCredentialSpec;
    public static final String JSON_PROPERTY_GMSA_CREDENTIAL_SPEC_NAME = "gmsaCredentialSpecName";
    private String gmsaCredentialSpecName;
    public static final String JSON_PROPERTY_RUN_AS_USER_NAME = "runAsUserName";
    private String runAsUserName;

    public IoK8sApiCoreV1WindowsSecurityContextOptions gmsaCredentialSpec(String gmsaCredentialSpec) {
        this.gmsaCredentialSpec = gmsaCredentialSpec;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GMSACredentialSpec is where the GMSA admission webhook (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the GMSA credential spec named by the GMSACredentialSpecName field.")
    @JsonProperty(value="gmsaCredentialSpec")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGmsaCredentialSpec() {
        return this.gmsaCredentialSpec;
    }

    public void setGmsaCredentialSpec(String gmsaCredentialSpec) {
        this.gmsaCredentialSpec = gmsaCredentialSpec;
    }

    public IoK8sApiCoreV1WindowsSecurityContextOptions gmsaCredentialSpecName(String gmsaCredentialSpecName) {
        this.gmsaCredentialSpecName = gmsaCredentialSpecName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="GMSACredentialSpecName is the name of the GMSA credential spec to use.")
    @JsonProperty(value="gmsaCredentialSpecName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGmsaCredentialSpecName() {
        return this.gmsaCredentialSpecName;
    }

    public void setGmsaCredentialSpecName(String gmsaCredentialSpecName) {
        this.gmsaCredentialSpecName = gmsaCredentialSpecName;
    }

    public IoK8sApiCoreV1WindowsSecurityContextOptions runAsUserName(String runAsUserName) {
        this.runAsUserName = runAsUserName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The UserName in Windows to run the entrypoint of the container process. Defaults to the user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.")
    @JsonProperty(value="runAsUserName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRunAsUserName() {
        return this.runAsUserName;
    }

    public void setRunAsUserName(String runAsUserName) {
        this.runAsUserName = runAsUserName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiCoreV1WindowsSecurityContextOptions ioK8sApiCoreV1WindowsSecurityContextOptions = (IoK8sApiCoreV1WindowsSecurityContextOptions)o;
        return Objects.equals(this.gmsaCredentialSpec, ioK8sApiCoreV1WindowsSecurityContextOptions.gmsaCredentialSpec) && Objects.equals(this.gmsaCredentialSpecName, ioK8sApiCoreV1WindowsSecurityContextOptions.gmsaCredentialSpecName) && Objects.equals(this.runAsUserName, ioK8sApiCoreV1WindowsSecurityContextOptions.runAsUserName);
    }

    public int hashCode() {
        return Objects.hash(this.gmsaCredentialSpec, this.gmsaCredentialSpecName, this.runAsUserName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiCoreV1WindowsSecurityContextOptions {\n");
        sb.append("    gmsaCredentialSpec: ").append(this.toIndentedString(this.gmsaCredentialSpec)).append("\n");
        sb.append("    gmsaCredentialSpecName: ").append(this.toIndentedString(this.gmsaCredentialSpecName)).append("\n");
        sb.append("    runAsUserName: ").append(this.toIndentedString(this.runAsUserName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

