/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="EndpointPort represents a Port used by an EndpointSlice")
@JsonPropertyOrder(value={"appProtocol", "name", "port", "protocol"})
public class IoK8sApiDiscoveryV1beta1EndpointPort {
    public static final String JSON_PROPERTY_APP_PROTOCOL = "appProtocol";
    private String appProtocol;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PORT = "port";
    private Integer port;
    public static final String JSON_PROPERTY_PROTOCOL = "protocol";
    private String protocol;

    public IoK8sApiDiscoveryV1beta1EndpointPort appProtocol(String appProtocol) {
        this.appProtocol = appProtocol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The application protocol for this port. This field follows standard Kubernetes label syntax. Un-prefixed names are reserved for IANA standard service names (as per RFC-6335 and http://www.iana.org/assignments/service-names). Non-standard protocols should use prefixed names such as mycompany.com/my-custom-protocol.")
    @JsonProperty(value="appProtocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAppProtocol() {
        return this.appProtocol;
    }

    public void setAppProtocol(String appProtocol) {
        this.appProtocol = appProtocol;
    }

    public IoK8sApiDiscoveryV1beta1EndpointPort name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of this port. All ports in an EndpointSlice must have a unique name. If the EndpointSlice is dervied from a Kubernetes service, this corresponds to the Service.ports[].name. Name must either be an empty string or pass DNS_LABEL validation: * must be no more than 63 characters long. * must consist of lower case alphanumeric characters or '-'. * must start and end with an alphanumeric character. Default is empty string.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IoK8sApiDiscoveryV1beta1EndpointPort port(Integer port) {
        this.port = port;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The port number of the endpoint. If this is not specified, ports are not restricted and must be interpreted in the context of the specific consumer.")
    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public IoK8sApiDiscoveryV1beta1EndpointPort protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP.")
    @JsonProperty(value="protocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiDiscoveryV1beta1EndpointPort ioK8sApiDiscoveryV1beta1EndpointPort = (IoK8sApiDiscoveryV1beta1EndpointPort)o;
        return Objects.equals(this.appProtocol, ioK8sApiDiscoveryV1beta1EndpointPort.appProtocol) && Objects.equals(this.name, ioK8sApiDiscoveryV1beta1EndpointPort.name) && Objects.equals(this.port, ioK8sApiDiscoveryV1beta1EndpointPort.port) && Objects.equals(this.protocol, ioK8sApiDiscoveryV1beta1EndpointPort.protocol);
    }

    public int hashCode() {
        return Objects.hash(this.appProtocol, this.name, this.port, this.protocol);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiDiscoveryV1beta1EndpointPort {\n");
        sb.append("    appProtocol: ").append(this.toIndentedString(this.appProtocol)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString(this.protocol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

