/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiDiscoveryV1beta1Endpoint;
import net.stickycode.kuuty.model.v18.IoK8sApiDiscoveryV1beta1EndpointPort;
import net.stickycode.kuuty.model.v18.IoK8sApimachineryPkgApisMetaV1ObjectMeta;

@ApiModel(description="EndpointSlice represents a subset of the endpoints that implement a service. For a given service there may be multiple EndpointSlice objects, selected by labels, which must be joined to produce the full set of endpoints.")
@JsonPropertyOrder(value={"addressType", "apiVersion", "endpoints", "kind", "metadata", "ports"})
public class IoK8sApiDiscoveryV1beta1EndpointSlice {
    public static final String JSON_PROPERTY_ADDRESS_TYPE = "addressType";
    private String addressType;
    public static final String JSON_PROPERTY_API_VERSION = "apiVersion";
    private String apiVersion;
    public static final String JSON_PROPERTY_ENDPOINTS = "endpoints";
    private List<IoK8sApiDiscoveryV1beta1Endpoint> endpoints = new ArrayList<IoK8sApiDiscoveryV1beta1Endpoint>();
    public static final String JSON_PROPERTY_KIND = "kind";
    private String kind;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private IoK8sApimachineryPkgApisMetaV1ObjectMeta metadata;
    public static final String JSON_PROPERTY_PORTS = "ports";
    private List<IoK8sApiDiscoveryV1beta1EndpointPort> ports = null;

    public IoK8sApiDiscoveryV1beta1EndpointSlice addressType(String addressType) {
        this.addressType = addressType;
        return this;
    }

    @ApiModelProperty(required=true, value="addressType specifies the type of address carried by this EndpointSlice. All addresses in this slice must be the same type. This field is immutable after creation. The following address types are currently supported: * IPv4: Represents an IPv4 Address. * IPv6: Represents an IPv6 Address. * FQDN: Represents a Fully Qualified Domain Name.")
    @JsonProperty(value="addressType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAddressType() {
        return this.addressType;
    }

    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    public IoK8sApiDiscoveryV1beta1EndpointSlice apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    @JsonProperty(value="apiVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public IoK8sApiDiscoveryV1beta1EndpointSlice endpoints(List<IoK8sApiDiscoveryV1beta1Endpoint> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public IoK8sApiDiscoveryV1beta1EndpointSlice addEndpointsItem(IoK8sApiDiscoveryV1beta1Endpoint endpointsItem) {
        this.endpoints.add(endpointsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="endpoints is a list of unique endpoints in this slice. Each slice may include a maximum of 1000 endpoints.")
    @JsonProperty(value="endpoints")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<IoK8sApiDiscoveryV1beta1Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<IoK8sApiDiscoveryV1beta1Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public IoK8sApiDiscoveryV1beta1EndpointSlice kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    @JsonProperty(value="kind")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public IoK8sApiDiscoveryV1beta1EndpointSlice metadata(IoK8sApimachineryPkgApisMetaV1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApimachineryPkgApisMetaV1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(IoK8sApimachineryPkgApisMetaV1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public IoK8sApiDiscoveryV1beta1EndpointSlice ports(List<IoK8sApiDiscoveryV1beta1EndpointPort> ports) {
        this.ports = ports;
        return this;
    }

    public IoK8sApiDiscoveryV1beta1EndpointSlice addPortsItem(IoK8sApiDiscoveryV1beta1EndpointPort portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<IoK8sApiDiscoveryV1beta1EndpointPort>();
        }
        this.ports.add(portsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ports specifies the list of network ports exposed by each endpoint in this slice. Each port must have a unique name. When ports is empty, it indicates that there are no defined ports. When a port is defined with a nil port value, it indicates \"all ports\". Each slice may include a maximum of 100 ports.")
    @JsonProperty(value="ports")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiDiscoveryV1beta1EndpointPort> getPorts() {
        return this.ports;
    }

    public void setPorts(List<IoK8sApiDiscoveryV1beta1EndpointPort> ports) {
        this.ports = ports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiDiscoveryV1beta1EndpointSlice ioK8sApiDiscoveryV1beta1EndpointSlice = (IoK8sApiDiscoveryV1beta1EndpointSlice)o;
        return Objects.equals(this.addressType, ioK8sApiDiscoveryV1beta1EndpointSlice.addressType) && Objects.equals(this.apiVersion, ioK8sApiDiscoveryV1beta1EndpointSlice.apiVersion) && Objects.equals(this.endpoints, ioK8sApiDiscoveryV1beta1EndpointSlice.endpoints) && Objects.equals(this.kind, ioK8sApiDiscoveryV1beta1EndpointSlice.kind) && Objects.equals(this.metadata, ioK8sApiDiscoveryV1beta1EndpointSlice.metadata) && Objects.equals(this.ports, ioK8sApiDiscoveryV1beta1EndpointSlice.ports);
    }

    public int hashCode() {
        return Objects.hash(this.addressType, this.apiVersion, this.endpoints, this.kind, this.metadata, this.ports);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiDiscoveryV1beta1EndpointSlice {\n");
        sb.append("    addressType: ").append(this.toIndentedString(this.addressType)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    endpoints: ").append(this.toIndentedString(this.endpoints)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

