/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiExtensionsV1beta1IngressBackend;

@ApiModel(description="HTTPIngressPath associates a path with a backend. Incoming urls matching the path are forwarded to the backend.")
@JsonPropertyOrder(value={"backend", "path", "pathType"})
public class IoK8sApiExtensionsV1beta1HTTPIngressPath {
    public static final String JSON_PROPERTY_BACKEND = "backend";
    private IoK8sApiExtensionsV1beta1IngressBackend backend;
    public static final String JSON_PROPERTY_PATH = "path";
    private String path;
    public static final String JSON_PROPERTY_PATH_TYPE = "pathType";
    private String pathType;

    public IoK8sApiExtensionsV1beta1HTTPIngressPath backend(IoK8sApiExtensionsV1beta1IngressBackend backend) {
        this.backend = backend;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="backend")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IoK8sApiExtensionsV1beta1IngressBackend getBackend() {
        return this.backend;
    }

    public void setBackend(IoK8sApiExtensionsV1beta1IngressBackend backend) {
        this.backend = backend;
    }

    public IoK8sApiExtensionsV1beta1HTTPIngressPath path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Path is matched against the path of an incoming request. Currently it can contain characters disallowed from the conventional \"path\" part of a URL as defined by RFC 3986. Paths must begin with a '/'. When unspecified, all paths from incoming requests are matched.")
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public IoK8sApiExtensionsV1beta1HTTPIngressPath pathType(String pathType) {
        this.pathType = pathType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PathType determines the interpretation of the Path matching. PathType can be one of the following values: * Exact: Matches the URL path exactly. * Prefix: Matches based on a URL path prefix split by '/'. Matching is   done on a path element by element basis. A path element refers is the   list of labels in the path split by the '/' separator. A request is a   match for path p if every p is an element-wise prefix of p of the   request path. Note that if the last element of the path is a substring   of the last element in request path, it is not a match (e.g. /foo/bar   matches /foo/bar/baz, but does not match /foo/barbaz). * ImplementationSpecific: Interpretation of the Path matching is up to   the IngressClass. Implementations can treat this as a separate PathType   or treat it identically to Prefix or Exact path types. Implementations are required to support all path types. Defaults to ImplementationSpecific.")
    @JsonProperty(value="pathType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPathType() {
        return this.pathType;
    }

    public void setPathType(String pathType) {
        this.pathType = pathType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiExtensionsV1beta1HTTPIngressPath ioK8sApiExtensionsV1beta1HTTPIngressPath = (IoK8sApiExtensionsV1beta1HTTPIngressPath)o;
        return Objects.equals(this.backend, ioK8sApiExtensionsV1beta1HTTPIngressPath.backend) && Objects.equals(this.path, ioK8sApiExtensionsV1beta1HTTPIngressPath.path) && Objects.equals(this.pathType, ioK8sApiExtensionsV1beta1HTTPIngressPath.pathType);
    }

    public int hashCode() {
        return Objects.hash(this.backend, this.path, this.pathType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiExtensionsV1beta1HTTPIngressPath {\n");
        sb.append("    backend: ").append(this.toIndentedString(this.backend)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    pathType: ").append(this.toIndentedString(this.pathType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

