/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiExtensionsV1beta1HTTPIngressRuleValue;

@ApiModel(description="IngressRule represents the rules mapping the paths under a specified host to the related backend services. Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.")
@JsonPropertyOrder(value={"host", "http"})
public class IoK8sApiExtensionsV1beta1IngressRule {
    public static final String JSON_PROPERTY_HOST = "host";
    private String host;
    public static final String JSON_PROPERTY_HTTP = "http";
    private IoK8sApiExtensionsV1beta1HTTPIngressRuleValue http;

    public IoK8sApiExtensionsV1beta1IngressRule host(String host) {
        this.host = host;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the \"host\" part of the URI as defined in RFC 3986: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to    the IP in the Spec of the parent Ingress. 2. The `:` delimiter is not respected because ports are not allowed.    Currently the port of an Ingress is implicitly :80 for http and    :443 for https. Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.  Host can be \"precise\" which is a domain name without the terminating dot of a network host (e.g. \"foo.bar.com\") or \"wildcard\", which is a domain name prefixed with a single wildcard label (e.g. \"*.foo.com\"). The wildcard character '*' must appear by itself as the first DNS label and matches only a single label. You cannot have a wildcard label by itself (e.g. Host == \"*\"). Requests will be matched against the Host field in the following way: 1. If Host is precise, the request matches this rule if the http host header is equal to Host. 2. If Host is a wildcard, then the request matches this rule if the http host header is to equal to the suffix (removing the first label) of the wildcard rule.")
    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public IoK8sApiExtensionsV1beta1IngressRule http(IoK8sApiExtensionsV1beta1HTTPIngressRuleValue http) {
        this.http = http;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="http")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiExtensionsV1beta1HTTPIngressRuleValue getHttp() {
        return this.http;
    }

    public void setHttp(IoK8sApiExtensionsV1beta1HTTPIngressRuleValue http) {
        this.http = http;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiExtensionsV1beta1IngressRule ioK8sApiExtensionsV1beta1IngressRule = (IoK8sApiExtensionsV1beta1IngressRule)o;
        return Objects.equals(this.host, ioK8sApiExtensionsV1beta1IngressRule.host) && Objects.equals(this.http, ioK8sApiExtensionsV1beta1IngressRule.http);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.http);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiExtensionsV1beta1IngressRule {\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    http: ").append(this.toIndentedString(this.http)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

