/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="IngressTLS describes the transport layer security associated with an Ingress.")
@JsonPropertyOrder(value={"hosts", "secretName"})
public class IoK8sApiExtensionsV1beta1IngressTLS {
    public static final String JSON_PROPERTY_HOSTS = "hosts";
    private List<String> hosts = null;
    public static final String JSON_PROPERTY_SECRET_NAME = "secretName";
    private String secretName;

    public IoK8sApiExtensionsV1beta1IngressTLS hosts(List<String> hosts) {
        this.hosts = hosts;
        return this;
    }

    public IoK8sApiExtensionsV1beta1IngressTLS addHostsItem(String hostsItem) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.add(hostsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Hosts are a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.")
    @JsonProperty(value="hosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    public IoK8sApiExtensionsV1beta1IngressTLS secretName(String secretName) {
        this.secretName = secretName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SecretName is the name of the secret used to terminate SSL traffic on 443. Field is left optional to allow SSL routing based on SNI hostname alone. If the SNI host in a listener conflicts with the \"Host\" header field used by an IngressRule, the SNI host is used for termination and value of the Host header is used for routing.")
    @JsonProperty(value="secretName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSecretName() {
        return this.secretName;
    }

    public void setSecretName(String secretName) {
        this.secretName = secretName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiExtensionsV1beta1IngressTLS ioK8sApiExtensionsV1beta1IngressTLS = (IoK8sApiExtensionsV1beta1IngressTLS)o;
        return Objects.equals(this.hosts, ioK8sApiExtensionsV1beta1IngressTLS.hosts) && Objects.equals(this.secretName, ioK8sApiExtensionsV1beta1IngressTLS.secretName);
    }

    public int hashCode() {
        return Objects.hash(this.hosts, this.secretName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiExtensionsV1beta1IngressTLS {\n");
        sb.append("    hosts: ").append(this.toIndentedString(this.hosts)).append("\n");
        sb.append("    secretName: ").append(this.toIndentedString(this.secretName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

