/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiFlowcontrolV1alpha1LimitResponse;

@ApiModel(description="LimitedPriorityLevelConfiguration specifies how to handle requests that are subject to limits. It addresses two issues:  * How are requests for this priority level limited?  * What should be done with requests that exceed the limit?")
@JsonPropertyOrder(value={"assuredConcurrencyShares", "limitResponse"})
public class IoK8sApiFlowcontrolV1alpha1LimitedPriorityLevelConfiguration {
    public static final String JSON_PROPERTY_ASSURED_CONCURRENCY_SHARES = "assuredConcurrencyShares";
    private Integer assuredConcurrencyShares;
    public static final String JSON_PROPERTY_LIMIT_RESPONSE = "limitResponse";
    private IoK8sApiFlowcontrolV1alpha1LimitResponse limitResponse;

    public IoK8sApiFlowcontrolV1alpha1LimitedPriorityLevelConfiguration assuredConcurrencyShares(Integer assuredConcurrencyShares) {
        this.assuredConcurrencyShares = assuredConcurrencyShares;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`assuredConcurrencyShares` (ACS) configures the execution limit, which is a limit on the number of requests of this priority level that may be exeucting at a given time.  ACS must be a positive number. The server's concurrency limit (SCL) is divided among the concurrency-controlled priority levels in proportion to their assured concurrency shares. This produces the assured concurrency value (ACV) --- the number of requests that may be executing at a time --- for each such priority level:              ACV(l) = ceil( SCL * ACS(l) / ( sum[priority levels k] ACS(k) ) )  bigger numbers of ACS mean more reserved concurrent requests (at the expense of every other PL). This field has a default value of 30.")
    @JsonProperty(value="assuredConcurrencyShares")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAssuredConcurrencyShares() {
        return this.assuredConcurrencyShares;
    }

    public void setAssuredConcurrencyShares(Integer assuredConcurrencyShares) {
        this.assuredConcurrencyShares = assuredConcurrencyShares;
    }

    public IoK8sApiFlowcontrolV1alpha1LimitedPriorityLevelConfiguration limitResponse(IoK8sApiFlowcontrolV1alpha1LimitResponse limitResponse) {
        this.limitResponse = limitResponse;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="limitResponse")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IoK8sApiFlowcontrolV1alpha1LimitResponse getLimitResponse() {
        return this.limitResponse;
    }

    public void setLimitResponse(IoK8sApiFlowcontrolV1alpha1LimitResponse limitResponse) {
        this.limitResponse = limitResponse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiFlowcontrolV1alpha1LimitedPriorityLevelConfiguration ioK8sApiFlowcontrolV1alpha1LimitedPriorityLevelConfiguration = (IoK8sApiFlowcontrolV1alpha1LimitedPriorityLevelConfiguration)o;
        return Objects.equals(this.assuredConcurrencyShares, ioK8sApiFlowcontrolV1alpha1LimitedPriorityLevelConfiguration.assuredConcurrencyShares) && Objects.equals(this.limitResponse, ioK8sApiFlowcontrolV1alpha1LimitedPriorityLevelConfiguration.limitResponse);
    }

    public int hashCode() {
        return Objects.hash(this.assuredConcurrencyShares, this.limitResponse);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiFlowcontrolV1alpha1LimitedPriorityLevelConfiguration {\n");
        sb.append("    assuredConcurrencyShares: ").append(this.toIndentedString(this.assuredConcurrencyShares)).append("\n");
        sb.append("    limitResponse: ").append(this.toIndentedString(this.limitResponse)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

