/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="NonResourcePolicyRule is a predicate that matches non-resource requests according to their verb and the target non-resource URL. A NonResourcePolicyRule matches a request if and only if both (a) at least one member of verbs matches the request and (b) at least one member of nonResourceURLs matches the request.")
@JsonPropertyOrder(value={"nonResourceURLs", "verbs"})
public class IoK8sApiFlowcontrolV1alpha1NonResourcePolicyRule {
    public static final String JSON_PROPERTY_NON_RESOURCE_U_R_LS = "nonResourceURLs";
    private List<String> nonResourceURLs = new ArrayList<String>();
    public static final String JSON_PROPERTY_VERBS = "verbs";
    private List<String> verbs = new ArrayList<String>();

    public IoK8sApiFlowcontrolV1alpha1NonResourcePolicyRule nonResourceURLs(List<String> nonResourceURLs) {
        this.nonResourceURLs = nonResourceURLs;
        return this;
    }

    public IoK8sApiFlowcontrolV1alpha1NonResourcePolicyRule addNonResourceURLsItem(String nonResourceURLsItem) {
        this.nonResourceURLs.add(nonResourceURLsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="`nonResourceURLs` is a set of url prefixes that a user should have access to and may not be empty. For example:   - \"/healthz\" is legal   - \"/hea*\" is illegal   - \"/hea\" is legal but matches nothing   - \"/hea/_*\" also matches nothing   - \"/healthz/_*\" matches all per-component health checks. \"*\" matches all non-resource urls. if it is present, it must be the only entry. Required.")
    @JsonProperty(value="nonResourceURLs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getNonResourceURLs() {
        return this.nonResourceURLs;
    }

    public void setNonResourceURLs(List<String> nonResourceURLs) {
        this.nonResourceURLs = nonResourceURLs;
    }

    public IoK8sApiFlowcontrolV1alpha1NonResourcePolicyRule verbs(List<String> verbs) {
        this.verbs = verbs;
        return this;
    }

    public IoK8sApiFlowcontrolV1alpha1NonResourcePolicyRule addVerbsItem(String verbsItem) {
        this.verbs.add(verbsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="`verbs` is a list of matching verbs and may not be empty. \"*\" matches all verbs. If it is present, it must be the only entry. Required.")
    @JsonProperty(value="verbs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getVerbs() {
        return this.verbs;
    }

    public void setVerbs(List<String> verbs) {
        this.verbs = verbs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiFlowcontrolV1alpha1NonResourcePolicyRule ioK8sApiFlowcontrolV1alpha1NonResourcePolicyRule = (IoK8sApiFlowcontrolV1alpha1NonResourcePolicyRule)o;
        return Objects.equals(this.nonResourceURLs, ioK8sApiFlowcontrolV1alpha1NonResourcePolicyRule.nonResourceURLs) && Objects.equals(this.verbs, ioK8sApiFlowcontrolV1alpha1NonResourcePolicyRule.verbs);
    }

    public int hashCode() {
        return Objects.hash(this.nonResourceURLs, this.verbs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiFlowcontrolV1alpha1NonResourcePolicyRule {\n");
        sb.append("    nonResourceURLs: ").append(this.toIndentedString(this.nonResourceURLs)).append("\n");
        sb.append("    verbs: ").append(this.toIndentedString(this.verbs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

