/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.kuuty.model.v18;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.stickycode.kuuty.model.v18.IoK8sApiFlowcontrolV1alpha1NonResourcePolicyRule;
import net.stickycode.kuuty.model.v18.IoK8sApiFlowcontrolV1alpha1ResourcePolicyRule;
import net.stickycode.kuuty.model.v18.IoK8sApiFlowcontrolV1alpha1Subject;

@ApiModel(description="PolicyRulesWithSubjects prescribes a test that applies to a request to an apiserver. The test considers the subject making the request, the verb being requested, and the resource to be acted upon. This PolicyRulesWithSubjects matches a request if and only if both (a) at least one member of subjects matches the request and (b) at least one member of resourceRules or nonResourceRules matches the request.")
@JsonPropertyOrder(value={"nonResourceRules", "resourceRules", "subjects"})
public class IoK8sApiFlowcontrolV1alpha1PolicyRulesWithSubjects {
    public static final String JSON_PROPERTY_NON_RESOURCE_RULES = "nonResourceRules";
    private List<IoK8sApiFlowcontrolV1alpha1NonResourcePolicyRule> nonResourceRules = null;
    public static final String JSON_PROPERTY_RESOURCE_RULES = "resourceRules";
    private List<IoK8sApiFlowcontrolV1alpha1ResourcePolicyRule> resourceRules = null;
    public static final String JSON_PROPERTY_SUBJECTS = "subjects";
    private List<IoK8sApiFlowcontrolV1alpha1Subject> subjects = new ArrayList<IoK8sApiFlowcontrolV1alpha1Subject>();

    public IoK8sApiFlowcontrolV1alpha1PolicyRulesWithSubjects nonResourceRules(List<IoK8sApiFlowcontrolV1alpha1NonResourcePolicyRule> nonResourceRules) {
        this.nonResourceRules = nonResourceRules;
        return this;
    }

    public IoK8sApiFlowcontrolV1alpha1PolicyRulesWithSubjects addNonResourceRulesItem(IoK8sApiFlowcontrolV1alpha1NonResourcePolicyRule nonResourceRulesItem) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList<IoK8sApiFlowcontrolV1alpha1NonResourcePolicyRule>();
        }
        this.nonResourceRules.add(nonResourceRulesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`nonResourceRules` is a list of NonResourcePolicyRules that identify matching requests according to their verb and the target non-resource URL.")
    @JsonProperty(value="nonResourceRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiFlowcontrolV1alpha1NonResourcePolicyRule> getNonResourceRules() {
        return this.nonResourceRules;
    }

    public void setNonResourceRules(List<IoK8sApiFlowcontrolV1alpha1NonResourcePolicyRule> nonResourceRules) {
        this.nonResourceRules = nonResourceRules;
    }

    public IoK8sApiFlowcontrolV1alpha1PolicyRulesWithSubjects resourceRules(List<IoK8sApiFlowcontrolV1alpha1ResourcePolicyRule> resourceRules) {
        this.resourceRules = resourceRules;
        return this;
    }

    public IoK8sApiFlowcontrolV1alpha1PolicyRulesWithSubjects addResourceRulesItem(IoK8sApiFlowcontrolV1alpha1ResourcePolicyRule resourceRulesItem) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList<IoK8sApiFlowcontrolV1alpha1ResourcePolicyRule>();
        }
        this.resourceRules.add(resourceRulesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`resourceRules` is a slice of ResourcePolicyRules that identify matching requests according to their verb and the target resource. At least one of `resourceRules` and `nonResourceRules` has to be non-empty.")
    @JsonProperty(value="resourceRules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IoK8sApiFlowcontrolV1alpha1ResourcePolicyRule> getResourceRules() {
        return this.resourceRules;
    }

    public void setResourceRules(List<IoK8sApiFlowcontrolV1alpha1ResourcePolicyRule> resourceRules) {
        this.resourceRules = resourceRules;
    }

    public IoK8sApiFlowcontrolV1alpha1PolicyRulesWithSubjects subjects(List<IoK8sApiFlowcontrolV1alpha1Subject> subjects) {
        this.subjects = subjects;
        return this;
    }

    public IoK8sApiFlowcontrolV1alpha1PolicyRulesWithSubjects addSubjectsItem(IoK8sApiFlowcontrolV1alpha1Subject subjectsItem) {
        this.subjects.add(subjectsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="subjects is the list of normal user, serviceaccount, or group that this rule cares about. There must be at least one member in this slice. A slice that includes both the system:authenticated and system:unauthenticated user groups matches every request. Required.")
    @JsonProperty(value="subjects")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<IoK8sApiFlowcontrolV1alpha1Subject> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List<IoK8sApiFlowcontrolV1alpha1Subject> subjects) {
        this.subjects = subjects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoK8sApiFlowcontrolV1alpha1PolicyRulesWithSubjects ioK8sApiFlowcontrolV1alpha1PolicyRulesWithSubjects = (IoK8sApiFlowcontrolV1alpha1PolicyRulesWithSubjects)o;
        return Objects.equals(this.nonResourceRules, ioK8sApiFlowcontrolV1alpha1PolicyRulesWithSubjects.nonResourceRules) && Objects.equals(this.resourceRules, ioK8sApiFlowcontrolV1alpha1PolicyRulesWithSubjects.resourceRules) && Objects.equals(this.subjects, ioK8sApiFlowcontrolV1alpha1PolicyRulesWithSubjects.subjects);
    }

    public int hashCode() {
        return Objects.hash(this.nonResourceRules, this.resourceRules, this.subjects);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IoK8sApiFlowcontrolV1alpha1PolicyRulesWithSubjects {\n");
        sb.append("    nonResourceRules: ").append(this.toIndentedString(this.nonResourceRules)).append("\n");
        sb.append("    resourceRules: ").append(this.toIndentedString(this.resourceRules)).append("\n");
        sb.append("    subjects: ").append(this.toIndentedString(this.subjects)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

